/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ComplianceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of AWS Config rules or AWS resources that are compliant and noncompliant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComplianceSummary implements StructuredPojo, ToCopyableBuilder<ComplianceSummary.Builder, ComplianceSummary> {
    private final ComplianceContributorCount compliantResourceCount;

    private final ComplianceContributorCount nonCompliantResourceCount;

    private final Instant complianceSummaryTimestamp;

    private ComplianceSummary(BuilderImpl builder) {
        this.compliantResourceCount = builder.compliantResourceCount;
        this.nonCompliantResourceCount = builder.nonCompliantResourceCount;
        this.complianceSummaryTimestamp = builder.complianceSummaryTimestamp;
    }

    /**
     * <p>
     * The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and 100 for
     * resources.
     * </p>
     * 
     * @return The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and
     *         100 for resources.
     */
    public ComplianceContributorCount compliantResourceCount() {
        return compliantResourceCount;
    }

    /**
     * <p>
     * The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules and 100
     * for resources.
     * </p>
     * 
     * @return The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules
     *         and 100 for resources.
     */
    public ComplianceContributorCount nonCompliantResourceCount() {
        return nonCompliantResourceCount;
    }

    /**
     * <p>
     * The time that AWS Config created the compliance summary.
     * </p>
     * 
     * @return The time that AWS Config created the compliance summary.
     */
    public Instant complianceSummaryTimestamp() {
        return complianceSummaryTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((compliantResourceCount() == null) ? 0 : compliantResourceCount().hashCode());
        hashCode = 31 * hashCode + ((nonCompliantResourceCount() == null) ? 0 : nonCompliantResourceCount().hashCode());
        hashCode = 31 * hashCode + ((complianceSummaryTimestamp() == null) ? 0 : complianceSummaryTimestamp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummary)) {
            return false;
        }
        ComplianceSummary other = (ComplianceSummary) obj;
        if (other.compliantResourceCount() == null ^ this.compliantResourceCount() == null) {
            return false;
        }
        if (other.compliantResourceCount() != null && !other.compliantResourceCount().equals(this.compliantResourceCount())) {
            return false;
        }
        if (other.nonCompliantResourceCount() == null ^ this.nonCompliantResourceCount() == null) {
            return false;
        }
        if (other.nonCompliantResourceCount() != null
                && !other.nonCompliantResourceCount().equals(this.nonCompliantResourceCount())) {
            return false;
        }
        if (other.complianceSummaryTimestamp() == null ^ this.complianceSummaryTimestamp() == null) {
            return false;
        }
        if (other.complianceSummaryTimestamp() != null
                && !other.complianceSummaryTimestamp().equals(this.complianceSummaryTimestamp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (compliantResourceCount() != null) {
            sb.append("CompliantResourceCount: ").append(compliantResourceCount()).append(",");
        }
        if (nonCompliantResourceCount() != null) {
            sb.append("NonCompliantResourceCount: ").append(nonCompliantResourceCount()).append(",");
        }
        if (complianceSummaryTimestamp() != null) {
            sb.append("ComplianceSummaryTimestamp: ").append(complianceSummaryTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompliantResourceCount":
            return Optional.of(clazz.cast(compliantResourceCount()));
        case "NonCompliantResourceCount":
            return Optional.of(clazz.cast(nonCompliantResourceCount()));
        case "ComplianceSummaryTimestamp":
            return Optional.of(clazz.cast(complianceSummaryTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceSummary> {
        /**
         * <p>
         * The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and 100
         * for resources.
         * </p>
         * 
         * @param compliantResourceCount
         *        The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules
         *        and 100 for resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount);

        /**
         * <p>
         * The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules and
         * 100 for resources.
         * </p>
         * 
         * @param nonCompliantResourceCount
         *        The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules
         *        and 100 for resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount);

        /**
         * <p>
         * The time that AWS Config created the compliance summary.
         * </p>
         * 
         * @param complianceSummaryTimestamp
         *        The time that AWS Config created the compliance summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummaryTimestamp(Instant complianceSummaryTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private ComplianceContributorCount compliantResourceCount;

        private ComplianceContributorCount nonCompliantResourceCount;

        private Instant complianceSummaryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummary model) {
            compliantResourceCount(model.compliantResourceCount);
            nonCompliantResourceCount(model.nonCompliantResourceCount);
            complianceSummaryTimestamp(model.complianceSummaryTimestamp);
        }

        public final ComplianceContributorCount.Builder getCompliantResourceCount() {
            return compliantResourceCount != null ? compliantResourceCount.toBuilder() : null;
        }

        @Override
        public final Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount;
            return this;
        }

        public final void setCompliantResourceCount(ComplianceContributorCount.BuilderImpl compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount != null ? compliantResourceCount.build() : null;
        }

        public final ComplianceContributorCount.Builder getNonCompliantResourceCount() {
            return nonCompliantResourceCount != null ? nonCompliantResourceCount.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount;
            return this;
        }

        public final void setNonCompliantResourceCount(ComplianceContributorCount.BuilderImpl nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount != null ? nonCompliantResourceCount.build() : null;
        }

        public final Instant getComplianceSummaryTimestamp() {
            return complianceSummaryTimestamp;
        }

        @Override
        public final Builder complianceSummaryTimestamp(Instant complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = complianceSummaryTimestamp;
            return this;
        }

        public final void setComplianceSummaryTimestamp(Instant complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = complianceSummaryTimestamp;
        }

        @Override
        public ComplianceSummary build() {
            return new ComplianceSummary(this);
        }
    }
}
