/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ComplianceSummaryByResourceTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of AWS resources of a specific type that are compliant or noncompliant, up to a maximum of 100 for each
 * compliance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComplianceSummaryByResourceType implements StructuredPojo,
        ToCopyableBuilder<ComplianceSummaryByResourceType.Builder, ComplianceSummaryByResourceType> {
    private final String resourceType;

    private final ComplianceSummary complianceSummary;

    private ComplianceSummaryByResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.complianceSummary = builder.complianceSummary;
    }

    /**
     * <p>
     * The type of AWS resource.
     * </p>
     * 
     * @return The type of AWS resource.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each compliance.
     * </p>
     * 
     * @return The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each
     *         compliance.
     */
    public ComplianceSummary complianceSummary() {
        return complianceSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((complianceSummary() == null) ? 0 : complianceSummary().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummaryByResourceType)) {
            return false;
        }
        ComplianceSummaryByResourceType other = (ComplianceSummaryByResourceType) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.complianceSummary() == null ^ this.complianceSummary() == null) {
            return false;
        }
        if (other.complianceSummary() != null && !other.complianceSummary().equals(this.complianceSummary())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (complianceSummary() != null) {
            sb.append("ComplianceSummary: ").append(complianceSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.of(clazz.cast(resourceType()));
        case "ComplianceSummary":
            return Optional.of(clazz.cast(complianceSummary()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceSummaryByResourceTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceSummaryByResourceType> {
        /**
         * <p>
         * The type of AWS resource.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each compliance.
         * </p>
         * 
         * @param complianceSummary
         *        The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each
         *        compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummary(ComplianceSummary complianceSummary);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummaryByResourceType model) {
            resourceType(model.resourceType);
            complianceSummary(model.complianceSummary);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return complianceSummary != null ? complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        @Override
        public ComplianceSummaryByResourceType build() {
            return new ComplianceSummaryByResourceType(this);
        }
    }
}
