/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DeliverConfigSnapshot</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeliverConfigSnapshotRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeliverConfigSnapshotRequest.Builder, DeliverConfigSnapshotRequest> {
    private final String deliveryChannelName;

    private DeliverConfigSnapshotRequest(BuilderImpl builder) {
        this.deliveryChannelName = builder.deliveryChannelName;
    }

    /**
     * <p>
     * The name of the delivery channel through which the snapshot is delivered.
     * </p>
     * 
     * @return The name of the delivery channel through which the snapshot is delivered.
     */
    public String deliveryChannelName() {
        return deliveryChannelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryChannelName() == null) ? 0 : deliveryChannelName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliverConfigSnapshotRequest)) {
            return false;
        }
        DeliverConfigSnapshotRequest other = (DeliverConfigSnapshotRequest) obj;
        if (other.deliveryChannelName() == null ^ this.deliveryChannelName() == null) {
            return false;
        }
        if (other.deliveryChannelName() != null && !other.deliveryChannelName().equals(this.deliveryChannelName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryChannelName() != null) {
            sb.append("DeliveryChannelName: ").append(deliveryChannelName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deliveryChannelName":
            return Optional.of(clazz.cast(deliveryChannelName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeliverConfigSnapshotRequest> {
        /**
         * <p>
         * The name of the delivery channel through which the snapshot is delivered.
         * </p>
         * 
         * @param deliveryChannelName
         *        The name of the delivery channel through which the snapshot is delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelName(String deliveryChannelName);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryChannelName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliverConfigSnapshotRequest model) {
            deliveryChannelName(model.deliveryChannelName);
        }

        public final String getDeliveryChannelName() {
            return deliveryChannelName;
        }

        @Override
        public final Builder deliveryChannelName(String deliveryChannelName) {
            this.deliveryChannelName = deliveryChannelName;
            return this;
        }

        public final void setDeliveryChannelName(String deliveryChannelName) {
            this.deliveryChannelName = deliveryChannelName;
        }

        @Override
        public DeliverConfigSnapshotRequest build() {
            return new DeliverConfigSnapshotRequest(this);
        }
    }
}
