/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.DeliveryChannelStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of a specified delivery channel.
 * </p>
 * <p>
 * Valid values: <code>Success</code> | <code>Failure</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeliveryChannelStatus implements StructuredPojo,
        ToCopyableBuilder<DeliveryChannelStatus.Builder, DeliveryChannelStatus> {
    private final String name;

    private final ConfigExportDeliveryInfo configSnapshotDeliveryInfo;

    private final ConfigExportDeliveryInfo configHistoryDeliveryInfo;

    private final ConfigStreamDeliveryInfo configStreamDeliveryInfo;

    private DeliveryChannelStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.configSnapshotDeliveryInfo = builder.configSnapshotDeliveryInfo;
        this.configHistoryDeliveryInfo = builder.configHistoryDeliveryInfo;
        this.configStreamDeliveryInfo = builder.configStreamDeliveryInfo;
    }

    /**
     * <p>
     * The name of the delivery channel.
     * </p>
     * 
     * @return The name of the delivery channel.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
     * </p>
     * 
     * @return A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
     */
    public ConfigExportDeliveryInfo configSnapshotDeliveryInfo() {
        return configSnapshotDeliveryInfo;
    }

    /**
     * <p>
     * A list that contains the status of the delivery of the configuration history to the specified Amazon S3 bucket.
     * </p>
     * 
     * @return A list that contains the status of the delivery of the configuration history to the specified Amazon S3
     *         bucket.
     */
    public ConfigExportDeliveryInfo configHistoryDeliveryInfo() {
        return configHistoryDeliveryInfo;
    }

    /**
     * <p>
     * A list containing the status of the delivery of the configuration stream notification to the specified Amazon SNS
     * topic.
     * </p>
     * 
     * @return A list containing the status of the delivery of the configuration stream notification to the specified
     *         Amazon SNS topic.
     */
    public ConfigStreamDeliveryInfo configStreamDeliveryInfo() {
        return configStreamDeliveryInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((configSnapshotDeliveryInfo() == null) ? 0 : configSnapshotDeliveryInfo().hashCode());
        hashCode = 31 * hashCode + ((configHistoryDeliveryInfo() == null) ? 0 : configHistoryDeliveryInfo().hashCode());
        hashCode = 31 * hashCode + ((configStreamDeliveryInfo() == null) ? 0 : configStreamDeliveryInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannelStatus)) {
            return false;
        }
        DeliveryChannelStatus other = (DeliveryChannelStatus) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.configSnapshotDeliveryInfo() == null ^ this.configSnapshotDeliveryInfo() == null) {
            return false;
        }
        if (other.configSnapshotDeliveryInfo() != null
                && !other.configSnapshotDeliveryInfo().equals(this.configSnapshotDeliveryInfo())) {
            return false;
        }
        if (other.configHistoryDeliveryInfo() == null ^ this.configHistoryDeliveryInfo() == null) {
            return false;
        }
        if (other.configHistoryDeliveryInfo() != null
                && !other.configHistoryDeliveryInfo().equals(this.configHistoryDeliveryInfo())) {
            return false;
        }
        if (other.configStreamDeliveryInfo() == null ^ this.configStreamDeliveryInfo() == null) {
            return false;
        }
        if (other.configStreamDeliveryInfo() != null && !other.configStreamDeliveryInfo().equals(this.configStreamDeliveryInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (configSnapshotDeliveryInfo() != null) {
            sb.append("ConfigSnapshotDeliveryInfo: ").append(configSnapshotDeliveryInfo()).append(",");
        }
        if (configHistoryDeliveryInfo() != null) {
            sb.append("ConfigHistoryDeliveryInfo: ").append(configHistoryDeliveryInfo()).append(",");
        }
        if (configStreamDeliveryInfo() != null) {
            sb.append("ConfigStreamDeliveryInfo: ").append(configStreamDeliveryInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "configSnapshotDeliveryInfo":
            return Optional.of(clazz.cast(configSnapshotDeliveryInfo()));
        case "configHistoryDeliveryInfo":
            return Optional.of(clazz.cast(configHistoryDeliveryInfo()));
        case "configStreamDeliveryInfo":
            return Optional.of(clazz.cast(configStreamDeliveryInfo()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryChannelStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeliveryChannelStatus> {
        /**
         * <p>
         * The name of the delivery channel.
         * </p>
         * 
         * @param name
         *        The name of the delivery channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
         * </p>
         * 
         * @param configSnapshotDeliveryInfo
         *        A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo configSnapshotDeliveryInfo);

        /**
         * <p>
         * A list that contains the status of the delivery of the configuration history to the specified Amazon S3
         * bucket.
         * </p>
         * 
         * @param configHistoryDeliveryInfo
         *        A list that contains the status of the delivery of the configuration history to the specified Amazon
         *        S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo configHistoryDeliveryInfo);

        /**
         * <p>
         * A list containing the status of the delivery of the configuration stream notification to the specified Amazon
         * SNS topic.
         * </p>
         * 
         * @param configStreamDeliveryInfo
         *        A list containing the status of the delivery of the configuration stream notification to the specified
         *        Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo configStreamDeliveryInfo);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ConfigExportDeliveryInfo configSnapshotDeliveryInfo;

        private ConfigExportDeliveryInfo configHistoryDeliveryInfo;

        private ConfigStreamDeliveryInfo configStreamDeliveryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannelStatus model) {
            name(model.name);
            configSnapshotDeliveryInfo(model.configSnapshotDeliveryInfo);
            configHistoryDeliveryInfo(model.configHistoryDeliveryInfo);
            configStreamDeliveryInfo(model.configStreamDeliveryInfo);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigSnapshotDeliveryInfo() {
            return configSnapshotDeliveryInfo != null ? configSnapshotDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo;
            return this;
        }

        public final void setConfigSnapshotDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo != null ? configSnapshotDeliveryInfo.build() : null;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigHistoryDeliveryInfo() {
            return configHistoryDeliveryInfo != null ? configHistoryDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo;
            return this;
        }

        public final void setConfigHistoryDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo != null ? configHistoryDeliveryInfo.build() : null;
        }

        public final ConfigStreamDeliveryInfo.Builder getConfigStreamDeliveryInfo() {
            return configStreamDeliveryInfo != null ? configStreamDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo;
            return this;
        }

        public final void setConfigStreamDeliveryInfo(ConfigStreamDeliveryInfo.BuilderImpl configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo != null ? configStreamDeliveryInfo.build() : null;
        }

        @Override
        public DeliveryChannelStatus build() {
            return new DeliveryChannelStatus(this);
        }
    }
}
