/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeComplianceByConfigRuleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeComplianceByConfigRuleRequest.Builder, DescribeComplianceByConfigRuleRequest> {
    private final List<String> configRuleNames;

    private final List<String> complianceTypes;

    private final String nextToken;

    private DescribeComplianceByConfigRuleRequest(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
        this.complianceTypes = builder.complianceTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specify one or more AWS Config rule names to filter the results by rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specify one or more AWS Config rule names to filter the results by rule.
     */
    public List<String> configRuleNames() {
        return configRuleNames;
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
     *         <code>INSUFFICIENT_DATA</code>.
     */
    public List<ComplianceType> complianceTypes() {
        return TypeConverter.convert(complianceTypes, ComplianceType::fromValue);
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
     *         <code>INSUFFICIENT_DATA</code>.
     */
    public List<String> complianceTypesStrings() {
        return complianceTypes;
    }

    /**
     * <p>
     * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>NextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configRuleNames() == null) ? 0 : configRuleNames().hashCode());
        hashCode = 31 * hashCode + ((complianceTypesStrings() == null) ? 0 : complianceTypesStrings().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByConfigRuleRequest)) {
            return false;
        }
        DescribeComplianceByConfigRuleRequest other = (DescribeComplianceByConfigRuleRequest) obj;
        if (other.configRuleNames() == null ^ this.configRuleNames() == null) {
            return false;
        }
        if (other.configRuleNames() != null && !other.configRuleNames().equals(this.configRuleNames())) {
            return false;
        }
        if (other.complianceTypesStrings() == null ^ this.complianceTypesStrings() == null) {
            return false;
        }
        if (other.complianceTypesStrings() != null && !other.complianceTypesStrings().equals(this.complianceTypesStrings())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configRuleNames() != null) {
            sb.append("ConfigRuleNames: ").append(configRuleNames()).append(",");
        }
        if (complianceTypesStrings() != null) {
            sb.append("ComplianceTypes: ").append(complianceTypesStrings()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleNames":
            return Optional.of(clazz.cast(configRuleNames()));
        case "ComplianceTypes":
            return Optional.of(clazz.cast(complianceTypesStrings()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeComplianceByConfigRuleRequest> {
        /**
         * <p>
         * Specify one or more AWS Config rule names to filter the results by rule.
         * </p>
         * 
         * @param configRuleNames
         *        Specify one or more AWS Config rule names to filter the results by rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * Specify one or more AWS Config rule names to filter the results by rule.
         * </p>
         * 
         * @param configRuleNames
         *        Specify one or more AWS Config rule names to filter the results by rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>
         * .
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>INSUFFICIENT_DATA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypes(Collection<String> complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>
         * .
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>INSUFFICIENT_DATA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypes(String... complianceTypes);

        /**
         * <p>
         * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<String> configRuleNames;

        private List<String> complianceTypes;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByConfigRuleRequest model) {
            configRuleNames(model.configRuleNames);
            complianceTypes(model.complianceTypes);
            nextToken(model.nextToken);
        }

        public final Collection<String> getConfigRuleNames() {
            return configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final Collection<String> getComplianceTypes() {
            return complianceTypes;
        }

        @Override
        public final Builder complianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(String... complianceTypes) {
            complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComplianceByConfigRuleRequest build() {
            return new DescribeComplianceByConfigRuleRequest(this);
        }
    }
}
