/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.EvaluationResultIdentifierMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Uniquely identifies an evaluation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EvaluationResultIdentifier implements StructuredPojo,
        ToCopyableBuilder<EvaluationResultIdentifier.Builder, EvaluationResultIdentifier> {
    private final EvaluationResultQualifier evaluationResultQualifier;

    private final Instant orderingTimestamp;

    private EvaluationResultIdentifier(BuilderImpl builder) {
        this.evaluationResultQualifier = builder.evaluationResultQualifier;
        this.orderingTimestamp = builder.orderingTimestamp;
    }

    /**
     * <p>
     * Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the evaluated
     * resource.
     * </p>
     * 
     * @return Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the
     *         evaluated resource.
     */
    public EvaluationResultQualifier evaluationResultQualifier() {
        return evaluationResultQualifier;
    }

    /**
     * <p>
     * The time of the event that triggered the evaluation of your AWS resources. The time can indicate when AWS Config
     * delivered a configuration item change notification, or it can indicate when AWS Config delivered the
     * configuration snapshot, depending on which event triggered the evaluation.
     * </p>
     * 
     * @return The time of the event that triggered the evaluation of your AWS resources. The time can indicate when AWS
     *         Config delivered a configuration item change notification, or it can indicate when AWS Config delivered
     *         the configuration snapshot, depending on which event triggered the evaluation.
     */
    public Instant orderingTimestamp() {
        return orderingTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((evaluationResultQualifier() == null) ? 0 : evaluationResultQualifier().hashCode());
        hashCode = 31 * hashCode + ((orderingTimestamp() == null) ? 0 : orderingTimestamp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResultIdentifier)) {
            return false;
        }
        EvaluationResultIdentifier other = (EvaluationResultIdentifier) obj;
        if (other.evaluationResultQualifier() == null ^ this.evaluationResultQualifier() == null) {
            return false;
        }
        if (other.evaluationResultQualifier() != null
                && !other.evaluationResultQualifier().equals(this.evaluationResultQualifier())) {
            return false;
        }
        if (other.orderingTimestamp() == null ^ this.orderingTimestamp() == null) {
            return false;
        }
        if (other.orderingTimestamp() != null && !other.orderingTimestamp().equals(this.orderingTimestamp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (evaluationResultQualifier() != null) {
            sb.append("EvaluationResultQualifier: ").append(evaluationResultQualifier()).append(",");
        }
        if (orderingTimestamp() != null) {
            sb.append("OrderingTimestamp: ").append(orderingTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationResultQualifier":
            return Optional.of(clazz.cast(evaluationResultQualifier()));
        case "OrderingTimestamp":
            return Optional.of(clazz.cast(orderingTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EvaluationResultIdentifier> {
        /**
         * <p>
         * Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the evaluated
         * resource.
         * </p>
         * 
         * @param evaluationResultQualifier
         *        Identifies an AWS Config rule used to evaluate an AWS resource, and provides the type and ID of the
         *        evaluated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResultQualifier(EvaluationResultQualifier evaluationResultQualifier);

        /**
         * <p>
         * The time of the event that triggered the evaluation of your AWS resources. The time can indicate when AWS
         * Config delivered a configuration item change notification, or it can indicate when AWS Config delivered the
         * configuration snapshot, depending on which event triggered the evaluation.
         * </p>
         * 
         * @param orderingTimestamp
         *        The time of the event that triggered the evaluation of your AWS resources. The time can indicate when
         *        AWS Config delivered a configuration item change notification, or it can indicate when AWS Config
         *        delivered the configuration snapshot, depending on which event triggered the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingTimestamp(Instant orderingTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationResultQualifier evaluationResultQualifier;

        private Instant orderingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResultIdentifier model) {
            evaluationResultQualifier(model.evaluationResultQualifier);
            orderingTimestamp(model.orderingTimestamp);
        }

        public final EvaluationResultQualifier.Builder getEvaluationResultQualifier() {
            return evaluationResultQualifier != null ? evaluationResultQualifier.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResultQualifier(EvaluationResultQualifier evaluationResultQualifier) {
            this.evaluationResultQualifier = evaluationResultQualifier;
            return this;
        }

        public final void setEvaluationResultQualifier(EvaluationResultQualifier.BuilderImpl evaluationResultQualifier) {
            this.evaluationResultQualifier = evaluationResultQualifier != null ? evaluationResultQualifier.build() : null;
        }

        public final Instant getOrderingTimestamp() {
            return orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        @Override
        public EvaluationResultIdentifier build() {
            return new EvaluationResultIdentifier(this);
        }
    }
}
