/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetComplianceSummaryByConfigRuleResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetComplianceSummaryByConfigRuleResponse.Builder, GetComplianceSummaryByConfigRuleResponse> {
    private final ComplianceSummary complianceSummary;

    private GetComplianceSummaryByConfigRuleResponse(BuilderImpl builder) {
        this.complianceSummary = builder.complianceSummary;
    }

    /**
     * <p>
     * The number of AWS Config rules that are compliant and the number that are noncompliant, up to a maximum of 25 for
     * each.
     * </p>
     * 
     * @return The number of AWS Config rules that are compliant and the number that are noncompliant, up to a maximum
     *         of 25 for each.
     */
    public ComplianceSummary complianceSummary() {
        return complianceSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((complianceSummary() == null) ? 0 : complianceSummary().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryByConfigRuleResponse)) {
            return false;
        }
        GetComplianceSummaryByConfigRuleResponse other = (GetComplianceSummaryByConfigRuleResponse) obj;
        if (other.complianceSummary() == null ^ this.complianceSummary() == null) {
            return false;
        }
        if (other.complianceSummary() != null && !other.complianceSummary().equals(this.complianceSummary())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (complianceSummary() != null) {
            sb.append("ComplianceSummary: ").append(complianceSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceSummary":
            return Optional.of(clazz.cast(complianceSummary()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetComplianceSummaryByConfigRuleResponse> {
        /**
         * <p>
         * The number of AWS Config rules that are compliant and the number that are noncompliant, up to a maximum of 25
         * for each.
         * </p>
         * 
         * @param complianceSummary
         *        The number of AWS Config rules that are compliant and the number that are noncompliant, up to a
         *        maximum of 25 for each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummary(ComplianceSummary complianceSummary);
    }

    static final class BuilderImpl implements Builder {
        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryByConfigRuleResponse model) {
            complianceSummary(model.complianceSummary);
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return complianceSummary != null ? complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        @Override
        public GetComplianceSummaryByConfigRuleResponse build() {
            return new GetComplianceSummaryByConfigRuleResponse(this);
        }
    }
}
