/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>PutConfigurationRecorder</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutConfigurationRecorderRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutConfigurationRecorderRequest.Builder, PutConfigurationRecorderRequest> {
    private final ConfigurationRecorder configurationRecorder;

    private PutConfigurationRecorderRequest(BuilderImpl builder) {
        this.configurationRecorder = builder.configurationRecorder;
    }

    /**
     * <p>
     * The configuration recorder object that records each configuration change made to the resources.
     * </p>
     * 
     * @return The configuration recorder object that records each configuration change made to the resources.
     */
    public ConfigurationRecorder configurationRecorder() {
        return configurationRecorder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationRecorder() == null) ? 0 : configurationRecorder().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationRecorderRequest)) {
            return false;
        }
        PutConfigurationRecorderRequest other = (PutConfigurationRecorderRequest) obj;
        if (other.configurationRecorder() == null ^ this.configurationRecorder() == null) {
            return false;
        }
        if (other.configurationRecorder() != null && !other.configurationRecorder().equals(this.configurationRecorder())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configurationRecorder() != null) {
            sb.append("ConfigurationRecorder: ").append(configurationRecorder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorder":
            return Optional.of(clazz.cast(configurationRecorder()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutConfigurationRecorderRequest> {
        /**
         * <p>
         * The configuration recorder object that records each configuration change made to the resources.
         * </p>
         * 
         * @param configurationRecorder
         *        The configuration recorder object that records each configuration change made to the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorder(ConfigurationRecorder configurationRecorder);
    }

    static final class BuilderImpl implements Builder {
        private ConfigurationRecorder configurationRecorder;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationRecorderRequest model) {
            configurationRecorder(model.configurationRecorder);
        }

        public final ConfigurationRecorder.Builder getConfigurationRecorder() {
            return configurationRecorder != null ? configurationRecorder.toBuilder() : null;
        }

        @Override
        public final Builder configurationRecorder(ConfigurationRecorder configurationRecorder) {
            this.configurationRecorder = configurationRecorder;
            return this;
        }

        public final void setConfigurationRecorder(ConfigurationRecorder.BuilderImpl configurationRecorder) {
            this.configurationRecorder = configurationRecorder != null ? configurationRecorder.build() : null;
        }

        @Override
        public PutConfigurationRecorderRequest build() {
            return new PutConfigurationRecorderRequest(this);
        }
    }
}
