/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutEvaluationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutEvaluationsRequest.Builder, PutEvaluationsRequest> {
    private final List<Evaluation> evaluations;

    private final String resultToken;

    private final Boolean testMode;

    private PutEvaluationsRequest(BuilderImpl builder) {
        this.evaluations = builder.evaluations;
        this.resultToken = builder.resultToken;
        this.testMode = builder.testMode;
    }

    /**
     * <p>
     * The assessments that the AWS Lambda function performs. Each evaluation identifies an AWS resource and indicates
     * whether it complies with the AWS Config rule that invokes the AWS Lambda function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The assessments that the AWS Lambda function performs. Each evaluation identifies an AWS resource and
     *         indicates whether it complies with the AWS Config rule that invokes the AWS Lambda function.
     */
    public List<Evaluation> evaluations() {
        return evaluations;
    }

    /**
     * <p>
     * An encrypted token that associates an evaluation with an AWS Config rule. Identifies the rule and the event that
     * triggered the evaluation
     * </p>
     * 
     * @return An encrypted token that associates an evaluation with an AWS Config rule. Identifies the rule and the
     *         event that triggered the evaluation
     */
    public String resultToken() {
        return resultToken;
    }

    /**
     * <p>
     * Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your AWS Lambda
     * function will deliver evaluation results to AWS Config. No updates occur to your existing evaluations, and
     * evaluation results are not sent to AWS Config.
     * </p>
     * <note>
     * <p>
     * When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for
     * the <code>ResultToken</code> parameter, but the value cannot be null.
     * </p>
     * </note>
     * 
     * @return Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your AWS
     *         Lambda function will deliver evaluation results to AWS Config. No updates occur to your existing
     *         evaluations, and evaluation results are not sent to AWS Config.</p> <note>
     *         <p>
     *         When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid
     *         value for the <code>ResultToken</code> parameter, but the value cannot be null.
     *         </p>
     */
    public Boolean testMode() {
        return testMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((evaluations() == null) ? 0 : evaluations().hashCode());
        hashCode = 31 * hashCode + ((resultToken() == null) ? 0 : resultToken().hashCode());
        hashCode = 31 * hashCode + ((testMode() == null) ? 0 : testMode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsRequest)) {
            return false;
        }
        PutEvaluationsRequest other = (PutEvaluationsRequest) obj;
        if (other.evaluations() == null ^ this.evaluations() == null) {
            return false;
        }
        if (other.evaluations() != null && !other.evaluations().equals(this.evaluations())) {
            return false;
        }
        if (other.resultToken() == null ^ this.resultToken() == null) {
            return false;
        }
        if (other.resultToken() != null && !other.resultToken().equals(this.resultToken())) {
            return false;
        }
        if (other.testMode() == null ^ this.testMode() == null) {
            return false;
        }
        if (other.testMode() != null && !other.testMode().equals(this.testMode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (evaluations() != null) {
            sb.append("Evaluations: ").append(evaluations()).append(",");
        }
        if (resultToken() != null) {
            sb.append("ResultToken: ").append(resultToken()).append(",");
        }
        if (testMode() != null) {
            sb.append("TestMode: ").append(testMode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluations":
            return Optional.of(clazz.cast(evaluations()));
        case "ResultToken":
            return Optional.of(clazz.cast(resultToken()));
        case "TestMode":
            return Optional.of(clazz.cast(testMode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutEvaluationsRequest> {
        /**
         * <p>
         * The assessments that the AWS Lambda function performs. Each evaluation identifies an AWS resource and
         * indicates whether it complies with the AWS Config rule that invokes the AWS Lambda function.
         * </p>
         * 
         * @param evaluations
         *        The assessments that the AWS Lambda function performs. Each evaluation identifies an AWS resource and
         *        indicates whether it complies with the AWS Config rule that invokes the AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluations(Collection<Evaluation> evaluations);

        /**
         * <p>
         * The assessments that the AWS Lambda function performs. Each evaluation identifies an AWS resource and
         * indicates whether it complies with the AWS Config rule that invokes the AWS Lambda function.
         * </p>
         * 
         * @param evaluations
         *        The assessments that the AWS Lambda function performs. Each evaluation identifies an AWS resource and
         *        indicates whether it complies with the AWS Config rule that invokes the AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluations(Evaluation... evaluations);

        /**
         * <p>
         * An encrypted token that associates an evaluation with an AWS Config rule. Identifies the rule and the event
         * that triggered the evaluation
         * </p>
         * 
         * @param resultToken
         *        An encrypted token that associates an evaluation with an AWS Config rule. Identifies the rule and the
         *        event that triggered the evaluation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultToken(String resultToken);

        /**
         * <p>
         * Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your AWS
         * Lambda function will deliver evaluation results to AWS Config. No updates occur to your existing evaluations,
         * and evaluation results are not sent to AWS Config.
         * </p>
         * <note>
         * <p>
         * When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value
         * for the <code>ResultToken</code> parameter, but the value cannot be null.
         * </p>
         * </note>
         * 
         * @param testMode
         *        Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your
         *        AWS Lambda function will deliver evaluation results to AWS Config. No updates occur to your existing
         *        evaluations, and evaluation results are not sent to AWS Config.</p> <note>
         *        <p>
         *        When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid
         *        value for the <code>ResultToken</code> parameter, but the value cannot be null.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testMode(Boolean testMode);
    }

    static final class BuilderImpl implements Builder {
        private List<Evaluation> evaluations;

        private String resultToken;

        private Boolean testMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEvaluationsRequest model) {
            evaluations(model.evaluations);
            resultToken(model.resultToken);
            testMode(model.testMode);
        }

        public final Collection<Evaluation.Builder> getEvaluations() {
            return evaluations != null ? evaluations.stream().map(Evaluation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder evaluations(Collection<Evaluation> evaluations) {
            this.evaluations = EvaluationsCopier.copy(evaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluations(Evaluation... evaluations) {
            evaluations(Arrays.asList(evaluations));
            return this;
        }

        public final void setEvaluations(Collection<Evaluation.BuilderImpl> evaluations) {
            this.evaluations = EvaluationsCopier.copyFromBuilder(evaluations);
        }

        public final String getResultToken() {
            return resultToken;
        }

        @Override
        public final Builder resultToken(String resultToken) {
            this.resultToken = resultToken;
            return this;
        }

        public final void setResultToken(String resultToken) {
            this.resultToken = resultToken;
        }

        public final Boolean getTestMode() {
            return testMode;
        }

        @Override
        public final Builder testMode(Boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public final void setTestMode(Boolean testMode) {
            this.testMode = testMode;
        }

        @Override
        public PutEvaluationsRequest build() {
            return new PutEvaluationsRequest(this);
        }
    }
}
