/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.config.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ConfigurationItem JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ConfigurationItemUnmarshaller implements Unmarshaller<ConfigurationItem, JsonUnmarshallerContext> {

    public ConfigurationItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConfigurationItem.Builder configurationItemBuilder = ConfigurationItem.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.version(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("accountId", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.accountId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("configurationItemCaptureTime", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configurationItemCaptureTime(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("configurationItemStatus", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configurationItemStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("configurationStateId", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configurationStateId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("configurationItemMD5Hash", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configurationItemMD5Hash(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.resourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("resourceId", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.resourceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("resourceName", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.resourceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("awsRegion", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.awsRegion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.availabilityZone(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("resourceCreationTime", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.resourceCreationTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.tags(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class),
                            context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("relatedEvents", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.relatedEvents(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("relationships", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.relationships(new ListUnmarshaller<Relationship>(RelationshipUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("configuration", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configuration(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("supplementaryConfiguration", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.supplementaryConfiguration(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return configurationItemBuilder.build();
    }

    private static final ConfigurationItemUnmarshaller INSTANCE = new ConfigurationItemUnmarshaller();

    public static ConfigurationItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}
