/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.config.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * ConfigurationRecorderStatusMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class ConfigurationRecorderStatusMarshaller {

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<java.time.Instant> LASTSTARTTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStartTime")
            .build();
    private static final MarshallingInfo<java.time.Instant> LASTSTOPTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStopTime")
            .build();
    private static final MarshallingInfo<Boolean> RECORDING_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recording").build();
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").build();
    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorCode").build();
    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorMessage").build();
    private static final MarshallingInfo<java.time.Instant> LASTSTATUSCHANGETIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("lastStatusChangeTime").build();

    private static final ConfigurationRecorderStatusMarshaller INSTANCE = new ConfigurationRecorderStatusMarshaller();

    public static ConfigurationRecorderStatusMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ConfigurationRecorderStatus configurationRecorderStatus, ProtocolMarshaller protocolMarshaller) {

        if (configurationRecorderStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(configurationRecorderStatus.name(), NAME_BINDING);

            protocolMarshaller.marshall(configurationRecorderStatus.lastStartTime(), LASTSTARTTIME_BINDING);

            protocolMarshaller.marshall(configurationRecorderStatus.lastStopTime(), LASTSTOPTIME_BINDING);

            protocolMarshaller.marshall(configurationRecorderStatus.recording(), RECORDING_BINDING);

            protocolMarshaller.marshall(configurationRecorderStatus.lastStatusString(), LASTSTATUS_BINDING);

            protocolMarshaller.marshall(configurationRecorderStatus.lastErrorCode(), LASTERRORCODE_BINDING);

            protocolMarshaller.marshall(configurationRecorderStatus.lastErrorMessage(), LASTERRORMESSAGE_BINDING);

            protocolMarshaller.marshall(configurationRecorderStatus.lastStatusChangeTime(), LASTSTATUSCHANGETIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
