/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.DeliveryStatus;
import software.amazon.awssdk.services.config.transform.ConfigExportDeliveryInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigExportDeliveryInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigExportDeliveryInfo> {
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastAttemptTime;
    private final Instant lastSuccessfulTime;
    private final Instant nextDeliveryTime;

    private ConfigExportDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastAttemptTime = builder.lastAttemptTime;
        this.lastSuccessfulTime = builder.lastSuccessfulTime;
        this.nextDeliveryTime = builder.nextDeliveryTime;
    }

    public DeliveryStatus lastStatus() {
        return DeliveryStatus.fromValue(this.lastStatus);
    }

    public String lastStatusString() {
        return this.lastStatus;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Instant lastAttemptTime() {
        return this.lastAttemptTime;
    }

    public Instant lastSuccessfulTime() {
        return this.lastSuccessfulTime;
    }

    public Instant nextDeliveryTime() {
        return this.nextDeliveryTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lastStatusString() == null ? 0 : this.lastStatusString().hashCode());
        hashCode = 31 * hashCode + (this.lastErrorCode() == null ? 0 : this.lastErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.lastErrorMessage() == null ? 0 : this.lastErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.lastAttemptTime() == null ? 0 : this.lastAttemptTime().hashCode());
        hashCode = 31 * hashCode + (this.lastSuccessfulTime() == null ? 0 : this.lastSuccessfulTime().hashCode());
        hashCode = 31 * hashCode + (this.nextDeliveryTime() == null ? 0 : this.nextDeliveryTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigExportDeliveryInfo)) {
            return false;
        }
        ConfigExportDeliveryInfo other = (ConfigExportDeliveryInfo)obj;
        if (other.lastStatusString() == null ^ this.lastStatusString() == null) {
            return false;
        }
        if (other.lastStatusString() != null && !other.lastStatusString().equals(this.lastStatusString())) {
            return false;
        }
        if (other.lastErrorCode() == null ^ this.lastErrorCode() == null) {
            return false;
        }
        if (other.lastErrorCode() != null && !other.lastErrorCode().equals(this.lastErrorCode())) {
            return false;
        }
        if (other.lastErrorMessage() == null ^ this.lastErrorMessage() == null) {
            return false;
        }
        if (other.lastErrorMessage() != null && !other.lastErrorMessage().equals(this.lastErrorMessage())) {
            return false;
        }
        if (other.lastAttemptTime() == null ^ this.lastAttemptTime() == null) {
            return false;
        }
        if (other.lastAttemptTime() != null && !other.lastAttemptTime().equals(this.lastAttemptTime())) {
            return false;
        }
        if (other.lastSuccessfulTime() == null ^ this.lastSuccessfulTime() == null) {
            return false;
        }
        if (other.lastSuccessfulTime() != null && !other.lastSuccessfulTime().equals(this.lastSuccessfulTime())) {
            return false;
        }
        if (other.nextDeliveryTime() == null ^ this.nextDeliveryTime() == null) {
            return false;
        }
        return other.nextDeliveryTime() == null || other.nextDeliveryTime().equals(this.nextDeliveryTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lastStatusString() != null) {
            sb.append("LastStatus: ").append(this.lastStatusString()).append(",");
        }
        if (this.lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(this.lastErrorCode()).append(",");
        }
        if (this.lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(this.lastErrorMessage()).append(",");
        }
        if (this.lastAttemptTime() != null) {
            sb.append("LastAttemptTime: ").append(this.lastAttemptTime()).append(",");
        }
        if (this.lastSuccessfulTime() != null) {
            sb.append("LastSuccessfulTime: ").append(this.lastSuccessfulTime()).append(",");
        }
        if (this.nextDeliveryTime() != null) {
            sb.append("NextDeliveryTime: ").append(this.nextDeliveryTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastStatus": {
                return Optional.of(clazz.cast(this.lastStatusString()));
            }
            case "lastErrorCode": {
                return Optional.of(clazz.cast(this.lastErrorCode()));
            }
            case "lastErrorMessage": {
                return Optional.of(clazz.cast(this.lastErrorMessage()));
            }
            case "lastAttemptTime": {
                return Optional.of(clazz.cast(this.lastAttemptTime()));
            }
            case "lastSuccessfulTime": {
                return Optional.of(clazz.cast(this.lastSuccessfulTime()));
            }
            case "nextDeliveryTime": {
                return Optional.of(clazz.cast(this.nextDeliveryTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigExportDeliveryInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastAttemptTime;
        private Instant lastSuccessfulTime;
        private Instant nextDeliveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigExportDeliveryInfo model) {
            this.lastStatus(model.lastStatus);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.lastAttemptTime(model.lastAttemptTime);
            this.lastSuccessfulTime(model.lastSuccessfulTime);
            this.nextDeliveryTime(model.nextDeliveryTime);
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastAttemptTime() {
            return this.lastAttemptTime;
        }

        @Override
        public final Builder lastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
            return this;
        }

        public final void setLastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
        }

        public final Instant getLastSuccessfulTime() {
            return this.lastSuccessfulTime;
        }

        @Override
        public final Builder lastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
            return this;
        }

        public final void setLastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
        }

        public final Instant getNextDeliveryTime() {
            return this.nextDeliveryTime;
        }

        @Override
        public final Builder nextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
            return this;
        }

        public final void setNextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
        }

        public ConfigExportDeliveryInfo build() {
            return new ConfigExportDeliveryInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigExportDeliveryInfo> {
        public Builder lastStatus(String var1);

        public Builder lastStatus(DeliveryStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastAttemptTime(Instant var1);

        public Builder lastSuccessfulTime(Instant var1);

        public Builder nextDeliveryTime(Instant var1);
    }
}

