/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.DeliveryStatus;
import software.amazon.awssdk.services.config.transform.ConfigStreamDeliveryInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigStreamDeliveryInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigStreamDeliveryInfo> {
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastStatusChangeTime;

    private ConfigStreamDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    public DeliveryStatus lastStatus() {
        return DeliveryStatus.fromValue(this.lastStatus);
    }

    public String lastStatusString() {
        return this.lastStatus;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Instant lastStatusChangeTime() {
        return this.lastStatusChangeTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lastStatusString() == null ? 0 : this.lastStatusString().hashCode());
        hashCode = 31 * hashCode + (this.lastErrorCode() == null ? 0 : this.lastErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.lastErrorMessage() == null ? 0 : this.lastErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.lastStatusChangeTime() == null ? 0 : this.lastStatusChangeTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigStreamDeliveryInfo)) {
            return false;
        }
        ConfigStreamDeliveryInfo other = (ConfigStreamDeliveryInfo)obj;
        if (other.lastStatusString() == null ^ this.lastStatusString() == null) {
            return false;
        }
        if (other.lastStatusString() != null && !other.lastStatusString().equals(this.lastStatusString())) {
            return false;
        }
        if (other.lastErrorCode() == null ^ this.lastErrorCode() == null) {
            return false;
        }
        if (other.lastErrorCode() != null && !other.lastErrorCode().equals(this.lastErrorCode())) {
            return false;
        }
        if (other.lastErrorMessage() == null ^ this.lastErrorMessage() == null) {
            return false;
        }
        if (other.lastErrorMessage() != null && !other.lastErrorMessage().equals(this.lastErrorMessage())) {
            return false;
        }
        if (other.lastStatusChangeTime() == null ^ this.lastStatusChangeTime() == null) {
            return false;
        }
        return other.lastStatusChangeTime() == null || other.lastStatusChangeTime().equals(this.lastStatusChangeTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lastStatusString() != null) {
            sb.append("LastStatus: ").append(this.lastStatusString()).append(",");
        }
        if (this.lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(this.lastErrorCode()).append(",");
        }
        if (this.lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(this.lastErrorMessage()).append(",");
        }
        if (this.lastStatusChangeTime() != null) {
            sb.append("LastStatusChangeTime: ").append(this.lastStatusChangeTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastStatus": {
                return Optional.of(clazz.cast(this.lastStatusString()));
            }
            case "lastErrorCode": {
                return Optional.of(clazz.cast(this.lastErrorCode()));
            }
            case "lastErrorMessage": {
                return Optional.of(clazz.cast(this.lastErrorMessage()));
            }
            case "lastStatusChangeTime": {
                return Optional.of(clazz.cast(this.lastStatusChangeTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigStreamDeliveryInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigStreamDeliveryInfo model) {
            this.lastStatus(model.lastStatus);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.lastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return this.lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        public ConfigStreamDeliveryInfo build() {
            return new ConfigStreamDeliveryInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigStreamDeliveryInfo> {
        public Builder lastStatus(String var1);

        public Builder lastStatus(DeliveryStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastStatusChangeTime(Instant var1);
    }
}

