/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo;
import software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo;
import software.amazon.awssdk.services.config.transform.DeliveryChannelStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeliveryChannelStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, DeliveryChannelStatus> {
    private final String name;
    private final ConfigExportDeliveryInfo configSnapshotDeliveryInfo;
    private final ConfigExportDeliveryInfo configHistoryDeliveryInfo;
    private final ConfigStreamDeliveryInfo configStreamDeliveryInfo;

    private DeliveryChannelStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.configSnapshotDeliveryInfo = builder.configSnapshotDeliveryInfo;
        this.configHistoryDeliveryInfo = builder.configHistoryDeliveryInfo;
        this.configStreamDeliveryInfo = builder.configStreamDeliveryInfo;
    }

    public String name() {
        return this.name;
    }

    public ConfigExportDeliveryInfo configSnapshotDeliveryInfo() {
        return this.configSnapshotDeliveryInfo;
    }

    public ConfigExportDeliveryInfo configHistoryDeliveryInfo() {
        return this.configHistoryDeliveryInfo;
    }

    public ConfigStreamDeliveryInfo configStreamDeliveryInfo() {
        return this.configStreamDeliveryInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.configSnapshotDeliveryInfo() == null ? 0 : this.configSnapshotDeliveryInfo().hashCode());
        hashCode = 31 * hashCode + (this.configHistoryDeliveryInfo() == null ? 0 : this.configHistoryDeliveryInfo().hashCode());
        hashCode = 31 * hashCode + (this.configStreamDeliveryInfo() == null ? 0 : this.configStreamDeliveryInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannelStatus)) {
            return false;
        }
        DeliveryChannelStatus other = (DeliveryChannelStatus)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.configSnapshotDeliveryInfo() == null ^ this.configSnapshotDeliveryInfo() == null) {
            return false;
        }
        if (other.configSnapshotDeliveryInfo() != null && !other.configSnapshotDeliveryInfo().equals(this.configSnapshotDeliveryInfo())) {
            return false;
        }
        if (other.configHistoryDeliveryInfo() == null ^ this.configHistoryDeliveryInfo() == null) {
            return false;
        }
        if (other.configHistoryDeliveryInfo() != null && !other.configHistoryDeliveryInfo().equals(this.configHistoryDeliveryInfo())) {
            return false;
        }
        if (other.configStreamDeliveryInfo() == null ^ this.configStreamDeliveryInfo() == null) {
            return false;
        }
        return other.configStreamDeliveryInfo() == null || other.configStreamDeliveryInfo().equals(this.configStreamDeliveryInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.configSnapshotDeliveryInfo() != null) {
            sb.append("ConfigSnapshotDeliveryInfo: ").append(this.configSnapshotDeliveryInfo()).append(",");
        }
        if (this.configHistoryDeliveryInfo() != null) {
            sb.append("ConfigHistoryDeliveryInfo: ").append(this.configHistoryDeliveryInfo()).append(",");
        }
        if (this.configStreamDeliveryInfo() != null) {
            sb.append("ConfigStreamDeliveryInfo: ").append(this.configStreamDeliveryInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "configSnapshotDeliveryInfo": {
                return Optional.of(clazz.cast(this.configSnapshotDeliveryInfo()));
            }
            case "configHistoryDeliveryInfo": {
                return Optional.of(clazz.cast(this.configHistoryDeliveryInfo()));
            }
            case "configStreamDeliveryInfo": {
                return Optional.of(clazz.cast(this.configStreamDeliveryInfo()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryChannelStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ConfigExportDeliveryInfo configSnapshotDeliveryInfo;
        private ConfigExportDeliveryInfo configHistoryDeliveryInfo;
        private ConfigStreamDeliveryInfo configStreamDeliveryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannelStatus model) {
            this.name(model.name);
            this.configSnapshotDeliveryInfo(model.configSnapshotDeliveryInfo);
            this.configHistoryDeliveryInfo(model.configHistoryDeliveryInfo);
            this.configStreamDeliveryInfo(model.configStreamDeliveryInfo);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigSnapshotDeliveryInfo() {
            return this.configSnapshotDeliveryInfo != null ? this.configSnapshotDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo;
            return this;
        }

        public final void setConfigSnapshotDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo != null ? configSnapshotDeliveryInfo.build() : null;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigHistoryDeliveryInfo() {
            return this.configHistoryDeliveryInfo != null ? this.configHistoryDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo;
            return this;
        }

        public final void setConfigHistoryDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo != null ? configHistoryDeliveryInfo.build() : null;
        }

        public final ConfigStreamDeliveryInfo.Builder getConfigStreamDeliveryInfo() {
            return this.configStreamDeliveryInfo != null ? this.configStreamDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo;
            return this;
        }

        public final void setConfigStreamDeliveryInfo(ConfigStreamDeliveryInfo.BuilderImpl configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo != null ? configStreamDeliveryInfo.build() : null;
        }

        public DeliveryChannelStatus build() {
            return new DeliveryChannelStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeliveryChannelStatus> {
        public Builder name(String var1);

        public Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo var1);

        public Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo var1);

        public Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo var1);
    }
}

