/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.EvaluationResultQualifierMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EvaluationResultQualifier
implements StructuredPojo,
ToCopyableBuilder<Builder, EvaluationResultQualifier> {
    private final String configRuleName;
    private final String resourceType;
    private final String resourceId;

    private EvaluationResultQualifier(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configRuleName() == null ? 0 : this.configRuleName().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResultQualifier)) {
            return false;
        }
        EvaluationResultQualifier other = (EvaluationResultQualifier)obj;
        if (other.configRuleName() == null ^ this.configRuleName() == null) {
            return false;
        }
        if (other.configRuleName() != null && !other.configRuleName().equals(this.configRuleName())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        return other.resourceId() == null || other.resourceId().equals(this.resourceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(this.configRuleName()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.of(clazz.cast(this.configRuleName()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultQualifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String resourceType;
        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResultQualifier model) {
            this.configRuleName(model.configRuleName);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public EvaluationResultQualifier build() {
            return new EvaluationResultQualifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EvaluationResultQualifier> {
        public Builder configRuleName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);
    }
}

