/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.config.model.ResourceIdListCopier;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDiscoveredResourcesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListDiscoveredResourcesRequest> {
    private final String resourceType;
    private final List<String> resourceIds;
    private final String resourceName;
    private final Integer limit;
    private final Boolean includeDeletedResources;
    private final String nextToken;

    private ListDiscoveredResourcesRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
        this.resourceName = builder.resourceName;
        this.limit = builder.limit;
        this.includeDeletedResources = builder.includeDeletedResources;
        this.nextToken = builder.nextToken;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean includeDeletedResources() {
        return this.includeDeletedResources;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceTypeString() == null ? 0 : this.resourceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.resourceIds() == null ? 0 : this.resourceIds().hashCode());
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.includeDeletedResources() == null ? 0 : this.includeDeletedResources().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesRequest)) {
            return false;
        }
        ListDiscoveredResourcesRequest other = (ListDiscoveredResourcesRequest)((Object)obj);
        if (other.resourceTypeString() == null ^ this.resourceTypeString() == null) {
            return false;
        }
        if (other.resourceTypeString() != null && !other.resourceTypeString().equals(this.resourceTypeString())) {
            return false;
        }
        if (other.resourceIds() == null ^ this.resourceIds() == null) {
            return false;
        }
        if (other.resourceIds() != null && !other.resourceIds().equals(this.resourceIds())) {
            return false;
        }
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.includeDeletedResources() == null ^ this.includeDeletedResources() == null) {
            return false;
        }
        if (other.includeDeletedResources() != null && !other.includeDeletedResources().equals(this.includeDeletedResources())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.resourceIds() != null) {
            sb.append("ResourceIds: ").append(this.resourceIds()).append(",");
        }
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.includeDeletedResources() != null) {
            sb.append("IncludeDeletedResources: ").append(this.includeDeletedResources()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "resourceIds": {
                return Optional.of(clazz.cast(this.resourceIds()));
            }
            case "resourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "includeDeletedResources": {
                return Optional.of(clazz.cast(this.includeDeletedResources()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private List<String> resourceIds;
        private String resourceName;
        private Integer limit;
        private Boolean includeDeletedResources;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesRequest model) {
            this.resourceType(model.resourceType);
            this.resourceIds(model.resourceIds);
            this.resourceName(model.resourceName);
            this.limit(model.limit);
            this.includeDeletedResources(model.includeDeletedResources);
            this.nextToken(model.nextToken);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceIds() {
            return this.resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdListCopier.copy(resourceIds);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getIncludeDeletedResources() {
            return this.includeDeletedResources;
        }

        @Override
        public final Builder includeDeletedResources(Boolean includeDeletedResources) {
            this.includeDeletedResources = includeDeletedResources;
            return this;
        }

        public final void setIncludeDeletedResources(Boolean includeDeletedResources) {
            this.includeDeletedResources = includeDeletedResources;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDiscoveredResourcesRequest build() {
            return new ListDiscoveredResourcesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDiscoveredResourcesRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder resourceName(String var1);

        public Builder limit(Integer var1);

        public Builder includeDeletedResources(Boolean var1);

        public Builder nextToken(String var1);
    }
}

