/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteEvaluationResultsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteEvaluationResultsRequest.Builder, DeleteEvaluationResultsRequest> {
    private final String configRuleName;

    private DeleteEvaluationResultsRequest(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
    }

    /**
     * <p>
     * The name of the Config rule for which you want to delete the evaluation results.
     * </p>
     * 
     * @return The name of the Config rule for which you want to delete the evaluation results.
     */
    public String configRuleName() {
        return configRuleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEvaluationResultsRequest)) {
            return false;
        }
        DeleteEvaluationResultsRequest other = (DeleteEvaluationResultsRequest) obj;
        return Objects.equals(configRuleName(), other.configRuleName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(configRuleName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.of(clazz.cast(configRuleName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteEvaluationResultsRequest> {
        /**
         * <p>
         * The name of the Config rule for which you want to delete the evaluation results.
         * </p>
         * 
         * @param configRuleName
         *        The name of the Config rule for which you want to delete the evaluation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEvaluationResultsRequest model) {
            configRuleName(model.configRuleName);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public DeleteEvaluationResultsRequest build() {
            return new DeleteEvaluationResultsRequest(this);
        }
    }
}
