/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigRulesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeConfigRulesResponse.Builder, DescribeConfigRulesResponse> {
    private final List<ConfigRule> configRules;

    private final String nextToken;

    private DescribeConfigRulesResponse(BuilderImpl builder) {
        this.configRules = builder.configRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The details about your AWS Config rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details about your AWS Config rules.
     */
    public List<ConfigRule> configRules() {
        return configRules;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRules());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRulesResponse)) {
            return false;
        }
        DescribeConfigRulesResponse other = (DescribeConfigRulesResponse) obj;
        return Objects.equals(configRules(), other.configRules()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configRules() != null) {
            sb.append("ConfigRules: ").append(configRules()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRules":
            return Optional.of(clazz.cast(configRules()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigRulesResponse> {
        /**
         * <p>
         * The details about your AWS Config rules.
         * </p>
         * 
         * @param configRules
         *        The details about your AWS Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRules(Collection<ConfigRule> configRules);

        /**
         * <p>
         * The details about your AWS Config rules.
         * </p>
         * 
         * @param configRules
         *        The details about your AWS Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRules(ConfigRule... configRules);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ConfigRule> configRules;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRulesResponse model) {
            configRules(model.configRules);
            nextToken(model.nextToken);
        }

        public final Collection<ConfigRule.Builder> getConfigRules() {
            return configRules != null ? configRules.stream().map(ConfigRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configRules(Collection<ConfigRule> configRules) {
            this.configRules = ConfigRulesCopier.copy(configRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRules(ConfigRule... configRules) {
            configRules(Arrays.asList(configRules));
            return this;
        }

        public final void setConfigRules(Collection<ConfigRule.BuilderImpl> configRules) {
            this.configRules = ConfigRulesCopier.copyFromBuilder(configRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigRulesResponse build() {
            return new DescribeConfigRulesResponse(this);
        }
    }
}
