/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeConfigurationRecorders</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationRecordersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeConfigurationRecordersResponse.Builder, DescribeConfigurationRecordersResponse> {
    private final List<ConfigurationRecorder> configurationRecorders;

    private DescribeConfigurationRecordersResponse(BuilderImpl builder) {
        this.configurationRecorders = builder.configurationRecorders;
    }

    /**
     * <p>
     * A list that contains the descriptions of the specified configuration recorders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains the descriptions of the specified configuration recorders.
     */
    public List<ConfigurationRecorder> configurationRecorders() {
        return configurationRecorders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationRecorders());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecordersResponse)) {
            return false;
        }
        DescribeConfigurationRecordersResponse other = (DescribeConfigurationRecordersResponse) obj;
        return Objects.equals(configurationRecorders(), other.configurationRecorders());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configurationRecorders() != null) {
            sb.append("ConfigurationRecorders: ").append(configurationRecorders()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorders":
            return Optional.of(clazz.cast(configurationRecorders()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigurationRecordersResponse> {
        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * 
         * @param configurationRecorders
         *        A list that contains the descriptions of the specified configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders);

        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * 
         * @param configurationRecorders
         *        A list that contains the descriptions of the specified configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorders(ConfigurationRecorder... configurationRecorders);
    }

    static final class BuilderImpl implements Builder {
        private List<ConfigurationRecorder> configurationRecorders;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecordersResponse model) {
            configurationRecorders(model.configurationRecorders);
        }

        public final Collection<ConfigurationRecorder.Builder> getConfigurationRecorders() {
            return configurationRecorders != null ? configurationRecorders.stream().map(ConfigurationRecorder::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copy(configurationRecorders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorders(ConfigurationRecorder... configurationRecorders) {
            configurationRecorders(Arrays.asList(configurationRecorders));
            return this;
        }

        public final void setConfigurationRecorders(Collection<ConfigurationRecorder.BuilderImpl> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copyFromBuilder(configurationRecorders);
        }

        @Override
        public DescribeConfigurationRecordersResponse build() {
            return new DescribeConfigurationRecordersResponse(this);
        }
    }
}
