/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetComplianceSummaryByResourceTypeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetComplianceSummaryByResourceTypeResponse.Builder, GetComplianceSummaryByResourceTypeResponse> {
    private final List<ComplianceSummaryByResourceType> complianceSummariesByResourceType;

    private GetComplianceSummaryByResourceTypeResponse(BuilderImpl builder) {
        this.complianceSummariesByResourceType = builder.complianceSummariesByResourceType;
    }

    /**
     * <p>
     * The number of resources that are compliant and the number that are noncompliant. If one or more resource types
     * were provided with the request, the numbers are returned for each resource type. The maximum number returned is
     * 100.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The number of resources that are compliant and the number that are noncompliant. If one or more resource
     *         types were provided with the request, the numbers are returned for each resource type. The maximum number
     *         returned is 100.
     */
    public List<ComplianceSummaryByResourceType> complianceSummariesByResourceType() {
        return complianceSummariesByResourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummariesByResourceType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryByResourceTypeResponse)) {
            return false;
        }
        GetComplianceSummaryByResourceTypeResponse other = (GetComplianceSummaryByResourceTypeResponse) obj;
        return Objects.equals(complianceSummariesByResourceType(), other.complianceSummariesByResourceType());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (complianceSummariesByResourceType() != null) {
            sb.append("ComplianceSummariesByResourceType: ").append(complianceSummariesByResourceType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceSummariesByResourceType":
            return Optional.of(clazz.cast(complianceSummariesByResourceType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetComplianceSummaryByResourceTypeResponse> {
        /**
         * <p>
         * The number of resources that are compliant and the number that are noncompliant. If one or more resource
         * types were provided with the request, the numbers are returned for each resource type. The maximum number
         * returned is 100.
         * </p>
         * 
         * @param complianceSummariesByResourceType
         *        The number of resources that are compliant and the number that are noncompliant. If one or more
         *        resource types were provided with the request, the numbers are returned for each resource type. The
         *        maximum number returned is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummariesByResourceType(Collection<ComplianceSummaryByResourceType> complianceSummariesByResourceType);

        /**
         * <p>
         * The number of resources that are compliant and the number that are noncompliant. If one or more resource
         * types were provided with the request, the numbers are returned for each resource type. The maximum number
         * returned is 100.
         * </p>
         * 
         * @param complianceSummariesByResourceType
         *        The number of resources that are compliant and the number that are noncompliant. If one or more
         *        resource types were provided with the request, the numbers are returned for each resource type. The
         *        maximum number returned is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummariesByResourceType(ComplianceSummaryByResourceType... complianceSummariesByResourceType);
    }

    static final class BuilderImpl implements Builder {
        private List<ComplianceSummaryByResourceType> complianceSummariesByResourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryByResourceTypeResponse model) {
            complianceSummariesByResourceType(model.complianceSummariesByResourceType);
        }

        public final Collection<ComplianceSummaryByResourceType.Builder> getComplianceSummariesByResourceType() {
            return complianceSummariesByResourceType != null ? complianceSummariesByResourceType.stream()
                    .map(ComplianceSummaryByResourceType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceSummariesByResourceType(
                Collection<ComplianceSummaryByResourceType> complianceSummariesByResourceType) {
            this.complianceSummariesByResourceType = ComplianceSummariesByResourceTypeCopier
                    .copy(complianceSummariesByResourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummariesByResourceType(
                ComplianceSummaryByResourceType... complianceSummariesByResourceType) {
            complianceSummariesByResourceType(Arrays.asList(complianceSummariesByResourceType));
            return this;
        }

        public final void setComplianceSummariesByResourceType(
                Collection<ComplianceSummaryByResourceType.BuilderImpl> complianceSummariesByResourceType) {
            this.complianceSummariesByResourceType = ComplianceSummariesByResourceTypeCopier
                    .copyFromBuilder(complianceSummariesByResourceType);
        }

        @Override
        public GetComplianceSummaryByResourceTypeResponse build() {
            return new GetComplianceSummaryByResourceTypeResponse(this);
        }
    }
}
