/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutEvaluationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutEvaluationsResponse.Builder, PutEvaluationsResponse> {
    private final List<Evaluation> failedEvaluations;

    private PutEvaluationsResponse(BuilderImpl builder) {
        this.failedEvaluations = builder.failedEvaluations;
    }

    /**
     * <p>
     * Requests that failed because of a client or server error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Requests that failed because of a client or server error.
     */
    public List<Evaluation> failedEvaluations() {
        return failedEvaluations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedEvaluations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsResponse)) {
            return false;
        }
        PutEvaluationsResponse other = (PutEvaluationsResponse) obj;
        return Objects.equals(failedEvaluations(), other.failedEvaluations());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (failedEvaluations() != null) {
            sb.append("FailedEvaluations: ").append(failedEvaluations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedEvaluations":
            return Optional.of(clazz.cast(failedEvaluations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutEvaluationsResponse> {
        /**
         * <p>
         * Requests that failed because of a client or server error.
         * </p>
         * 
         * @param failedEvaluations
         *        Requests that failed because of a client or server error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEvaluations(Collection<Evaluation> failedEvaluations);

        /**
         * <p>
         * Requests that failed because of a client or server error.
         * </p>
         * 
         * @param failedEvaluations
         *        Requests that failed because of a client or server error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEvaluations(Evaluation... failedEvaluations);
    }

    static final class BuilderImpl implements Builder {
        private List<Evaluation> failedEvaluations;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEvaluationsResponse model) {
            failedEvaluations(model.failedEvaluations);
        }

        public final Collection<Evaluation.Builder> getFailedEvaluations() {
            return failedEvaluations != null ? failedEvaluations.stream().map(Evaluation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder failedEvaluations(Collection<Evaluation> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copy(failedEvaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEvaluations(Evaluation... failedEvaluations) {
            failedEvaluations(Arrays.asList(failedEvaluations));
            return this;
        }

        public final void setFailedEvaluations(Collection<Evaluation.BuilderImpl> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copyFromBuilder(failedEvaluations);
        }

        @Override
        public PutEvaluationsResponse build() {
            return new PutEvaluationsResponse(this);
        }
    }
}
