/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.RecorderStatus;
import software.amazon.awssdk.services.config.transform.ConfigurationRecorderStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationRecorderStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationRecorderStatus> {
    private final String name;
    private final Instant lastStartTime;
    private final Instant lastStopTime;
    private final Boolean recording;
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastStatusChangeTime;

    private ConfigurationRecorderStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.recording = builder.recording;
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    public String name() {
        return this.name;
    }

    public Instant lastStartTime() {
        return this.lastStartTime;
    }

    public Instant lastStopTime() {
        return this.lastStopTime;
    }

    public Boolean recording() {
        return this.recording;
    }

    public RecorderStatus lastStatus() {
        return RecorderStatus.fromValue(this.lastStatus);
    }

    public String lastStatusString() {
        return this.lastStatus;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Instant lastStatusChangeTime() {
        return this.lastStatusChangeTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recording());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChangeTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderStatus)) {
            return false;
        }
        ConfigurationRecorderStatus other = (ConfigurationRecorderStatus)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.lastStartTime(), other.lastStartTime()) && Objects.equals(this.lastStopTime(), other.lastStopTime()) && Objects.equals(this.recording(), other.recording()) && Objects.equals(this.lastStatusString(), other.lastStatusString()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage()) && Objects.equals(this.lastStatusChangeTime(), other.lastStatusChangeTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.lastStartTime() != null) {
            sb.append("LastStartTime: ").append(this.lastStartTime()).append(",");
        }
        if (this.lastStopTime() != null) {
            sb.append("LastStopTime: ").append(this.lastStopTime()).append(",");
        }
        if (this.recording() != null) {
            sb.append("Recording: ").append(this.recording()).append(",");
        }
        if (this.lastStatusString() != null) {
            sb.append("LastStatus: ").append(this.lastStatusString()).append(",");
        }
        if (this.lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(this.lastErrorCode()).append(",");
        }
        if (this.lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(this.lastErrorMessage()).append(",");
        }
        if (this.lastStatusChangeTime() != null) {
            sb.append("LastStatusChangeTime: ").append(this.lastStatusChangeTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "lastStartTime": {
                return Optional.of(clazz.cast(this.lastStartTime()));
            }
            case "lastStopTime": {
                return Optional.of(clazz.cast(this.lastStopTime()));
            }
            case "recording": {
                return Optional.of(clazz.cast(this.recording()));
            }
            case "lastStatus": {
                return Optional.of(clazz.cast(this.lastStatusString()));
            }
            case "lastErrorCode": {
                return Optional.of(clazz.cast(this.lastErrorCode()));
            }
            case "lastErrorMessage": {
                return Optional.of(clazz.cast(this.lastErrorMessage()));
            }
            case "lastStatusChangeTime": {
                return Optional.of(clazz.cast(this.lastStatusChangeTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationRecorderStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Instant lastStartTime;
        private Instant lastStopTime;
        private Boolean recording;
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderStatus model) {
            this.name(model.name);
            this.lastStartTime(model.lastStartTime);
            this.lastStopTime(model.lastStopTime);
            this.recording(model.recording);
            this.lastStatus(model.lastStatus);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.lastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getLastStartTime() {
            return this.lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        public final Instant getLastStopTime() {
            return this.lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        public final Boolean getRecording() {
            return this.recording;
        }

        @Override
        public final Builder recording(Boolean recording) {
            this.recording = recording;
            return this;
        }

        public final void setRecording(Boolean recording) {
            this.recording = recording;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return this.lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        public ConfigurationRecorderStatus build() {
            return new ConfigurationRecorderStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationRecorderStatus> {
        public Builder name(String var1);

        public Builder lastStartTime(Instant var1);

        public Builder lastStopTime(Instant var1);

        public Builder recording(Boolean var1);

        public Builder lastStatus(String var1);

        public Builder lastStatus(RecorderStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastStatusChangeTime(Instant var1);
    }
}

