/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigSnapshotDeliveryProperties;
import software.amazon.awssdk.services.config.transform.DeliveryChannelMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeliveryChannel
implements StructuredPojo,
ToCopyableBuilder<Builder, DeliveryChannel> {
    private final String name;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String snsTopicARN;
    private final ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties;

    private DeliveryChannel(BuilderImpl builder) {
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicARN = builder.snsTopicARN;
        this.configSnapshotDeliveryProperties = builder.configSnapshotDeliveryProperties;
    }

    public String name() {
        return this.name;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public String snsTopicARN() {
        return this.snsTopicARN;
    }

    public ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties() {
        return this.configSnapshotDeliveryProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.configSnapshotDeliveryProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannel)) {
            return false;
        }
        DeliveryChannel other = (DeliveryChannel)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.snsTopicARN(), other.snsTopicARN()) && Objects.equals(this.configSnapshotDeliveryProperties(), other.configSnapshotDeliveryProperties());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.s3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.s3BucketName()).append(",");
        }
        if (this.s3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(this.s3KeyPrefix()).append(",");
        }
        if (this.snsTopicARN() != null) {
            sb.append("SnsTopicARN: ").append(this.snsTopicARN()).append(",");
        }
        if (this.configSnapshotDeliveryProperties() != null) {
            sb.append("ConfigSnapshotDeliveryProperties: ").append(this.configSnapshotDeliveryProperties()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "s3BucketName": {
                return Optional.of(clazz.cast(this.s3BucketName()));
            }
            case "s3KeyPrefix": {
                return Optional.of(clazz.cast(this.s3KeyPrefix()));
            }
            case "snsTopicARN": {
                return Optional.of(clazz.cast(this.snsTopicARN()));
            }
            case "configSnapshotDeliveryProperties": {
                return Optional.of(clazz.cast(this.configSnapshotDeliveryProperties()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String s3BucketName;
        private String s3KeyPrefix;
        private String snsTopicARN;
        private ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannel model) {
            this.name(model.name);
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.snsTopicARN(model.snsTopicARN);
            this.configSnapshotDeliveryProperties(model.configSnapshotDeliveryProperties);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getSnsTopicARN() {
            return this.snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        public final ConfigSnapshotDeliveryProperties.Builder getConfigSnapshotDeliveryProperties() {
            return this.configSnapshotDeliveryProperties != null ? this.configSnapshotDeliveryProperties.toBuilder() : null;
        }

        @Override
        public final Builder configSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties) {
            this.configSnapshotDeliveryProperties = configSnapshotDeliveryProperties;
            return this;
        }

        public final void setConfigSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties.BuilderImpl configSnapshotDeliveryProperties) {
            this.configSnapshotDeliveryProperties = configSnapshotDeliveryProperties != null ? configSnapshotDeliveryProperties.build() : null;
        }

        public DeliveryChannel build() {
            return new DeliveryChannel(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeliveryChannel> {
        public Builder name(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder snsTopicARN(String var1);

        public Builder configSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties var1);

        default public Builder configSnapshotDeliveryProperties(Consumer<ConfigSnapshotDeliveryProperties.Builder> configSnapshotDeliveryProperties) {
            return this.configSnapshotDeliveryProperties((ConfigSnapshotDeliveryProperties)((ConfigSnapshotDeliveryProperties.Builder)ConfigSnapshotDeliveryProperties.builder().apply(configSnapshotDeliveryProperties)).build());
        }
    }
}

