/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.EvaluationResult;

@SdkInternalApi
public class EvaluationResultMarshaller {
    private static final MarshallingInfo<StructuredPojo> EVALUATIONRESULTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationResultIdentifier").build();
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").build();
    private static final MarshallingInfo<Instant> RESULTRECORDEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultRecordedTime").build();
    private static final MarshallingInfo<Instant> CONFIGRULEINVOKEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleInvokedTime").build();
    private static final MarshallingInfo<String> ANNOTATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Annotation").build();
    private static final MarshallingInfo<String> RESULTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultToken").build();
    private static final EvaluationResultMarshaller INSTANCE = new EvaluationResultMarshaller();

    public static EvaluationResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EvaluationResult evaluationResult, ProtocolMarshaller protocolMarshaller) {
        if (evaluationResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)evaluationResult.evaluationResultIdentifier(), EVALUATIONRESULTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.complianceTypeString(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.resultRecordedTime(), RESULTRECORDEDTIME_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.configRuleInvokedTime(), CONFIGRULEINVOKEDTIME_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.annotation(), ANNOTATION_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.resultToken(), RESULTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

