/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ResourceCount;

@SdkInternalApi
public class ResourceCountMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<Long> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final ResourceCountMarshaller INSTANCE = new ResourceCountMarshaller();

    public static ResourceCountMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceCount resourceCount, ProtocolMarshaller protocolMarshaller) {
        if (resourceCount == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceCount.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceCount.count(), COUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

