/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.ResourceCount;

public class ResourceCountUnmarshaller
implements Unmarshaller<ResourceCount, JsonUnmarshallerContext> {
    private static final ResourceCountUnmarshaller INSTANCE = new ResourceCountUnmarshaller();

    public ResourceCount unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceCount.Builder resourceCountBuilder = ResourceCount.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    resourceCountBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("count", targetDepth)) {
                    context.nextToken();
                    resourceCountBuilder.count((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceCount)resourceCountBuilder.build();
    }

    public static ResourceCountUnmarshaller getInstance() {
        return INSTANCE;
    }
}

