/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigExportDeliveryInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides status of the delivery of the snapshot or the configuration history to the specified Amazon S3 bucket. Also
 * provides the status of notifications about the Amazon S3 delivery to the specified Amazon SNS topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigExportDeliveryInfo implements StructuredPojo,
        ToCopyableBuilder<ConfigExportDeliveryInfo.Builder, ConfigExportDeliveryInfo> {
    private final String lastStatus;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Instant lastAttemptTime;

    private final Instant lastSuccessfulTime;

    private final Instant nextDeliveryTime;

    private ConfigExportDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastAttemptTime = builder.lastAttemptTime;
        this.lastSuccessfulTime = builder.lastSuccessfulTime;
        this.nextDeliveryTime = builder.nextDeliveryTime;
    }

    /**
     * <p>
     * Status of the last attempted delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link DeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusString}.
     * </p>
     * 
     * @return Status of the last attempted delivery.
     * @see DeliveryStatus
     */
    public DeliveryStatus lastStatus() {
        return DeliveryStatus.fromValue(lastStatus);
    }

    /**
     * <p>
     * Status of the last attempted delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link DeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusString}.
     * </p>
     * 
     * @return Status of the last attempted delivery.
     * @see DeliveryStatus
     */
    public String lastStatusString() {
        return lastStatus;
    }

    /**
     * <p>
     * The error code from the last attempted delivery.
     * </p>
     * 
     * @return The error code from the last attempted delivery.
     */
    public String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The error message from the last attempted delivery.
     * </p>
     * 
     * @return The error message from the last attempted delivery.
     */
    public String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * The time of the last attempted delivery.
     * </p>
     * 
     * @return The time of the last attempted delivery.
     */
    public Instant lastAttemptTime() {
        return lastAttemptTime;
    }

    /**
     * <p>
     * The time of the last successful delivery.
     * </p>
     * 
     * @return The time of the last successful delivery.
     */
    public Instant lastSuccessfulTime() {
        return lastSuccessfulTime;
    }

    /**
     * <p>
     * The time that the next delivery occurs.
     * </p>
     * 
     * @return The time that the next delivery occurs.
     */
    public Instant nextDeliveryTime() {
        return nextDeliveryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextDeliveryTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigExportDeliveryInfo)) {
            return false;
        }
        ConfigExportDeliveryInfo other = (ConfigExportDeliveryInfo) obj;
        return Objects.equals(lastStatusString(), other.lastStatusString())
                && Objects.equals(lastErrorCode(), other.lastErrorCode())
                && Objects.equals(lastErrorMessage(), other.lastErrorMessage())
                && Objects.equals(lastAttemptTime(), other.lastAttemptTime())
                && Objects.equals(lastSuccessfulTime(), other.lastSuccessfulTime())
                && Objects.equals(nextDeliveryTime(), other.nextDeliveryTime());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (lastStatusString() != null) {
            sb.append("LastStatus: ").append(lastStatusString()).append(",");
        }
        if (lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(lastErrorCode()).append(",");
        }
        if (lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(lastErrorMessage()).append(",");
        }
        if (lastAttemptTime() != null) {
            sb.append("LastAttemptTime: ").append(lastAttemptTime()).append(",");
        }
        if (lastSuccessfulTime() != null) {
            sb.append("LastSuccessfulTime: ").append(lastSuccessfulTime()).append(",");
        }
        if (nextDeliveryTime() != null) {
            sb.append("NextDeliveryTime: ").append(nextDeliveryTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastStatus":
            return Optional.of(clazz.cast(lastStatusString()));
        case "lastErrorCode":
            return Optional.of(clazz.cast(lastErrorCode()));
        case "lastErrorMessage":
            return Optional.of(clazz.cast(lastErrorMessage()));
        case "lastAttemptTime":
            return Optional.of(clazz.cast(lastAttemptTime()));
        case "lastSuccessfulTime":
            return Optional.of(clazz.cast(lastSuccessfulTime()));
        case "nextDeliveryTime":
            return Optional.of(clazz.cast(nextDeliveryTime()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigExportDeliveryInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigExportDeliveryInfo> {
        /**
         * <p>
         * Status of the last attempted delivery.
         * </p>
         * 
         * @param lastStatus
         *        Status of the last attempted delivery.
         * @see DeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * Status of the last attempted delivery.
         * </p>
         * 
         * @param lastStatus
         *        Status of the last attempted delivery.
         * @see DeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder lastStatus(DeliveryStatus lastStatus);

        /**
         * <p>
         * The error code from the last attempted delivery.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code from the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The error message from the last attempted delivery.
         * </p>
         * 
         * @param lastErrorMessage
         *        The error message from the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * The time of the last attempted delivery.
         * </p>
         * 
         * @param lastAttemptTime
         *        The time of the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptTime(Instant lastAttemptTime);

        /**
         * <p>
         * The time of the last successful delivery.
         * </p>
         * 
         * @param lastSuccessfulTime
         *        The time of the last successful delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulTime(Instant lastSuccessfulTime);

        /**
         * <p>
         * The time that the next delivery occurs.
         * </p>
         * 
         * @param nextDeliveryTime
         *        The time that the next delivery occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextDeliveryTime(Instant nextDeliveryTime);
    }

    static final class BuilderImpl implements Builder {
        private String lastStatus;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Instant lastAttemptTime;

        private Instant lastSuccessfulTime;

        private Instant nextDeliveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigExportDeliveryInfo model) {
            lastStatus(model.lastStatus);
            lastErrorCode(model.lastErrorCode);
            lastErrorMessage(model.lastErrorMessage);
            lastAttemptTime(model.lastAttemptTime);
            lastSuccessfulTime(model.lastSuccessfulTime);
            nextDeliveryTime(model.nextDeliveryTime);
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastAttemptTime() {
            return lastAttemptTime;
        }

        @Override
        public final Builder lastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
            return this;
        }

        public final void setLastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
        }

        public final Instant getLastSuccessfulTime() {
            return lastSuccessfulTime;
        }

        @Override
        public final Builder lastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
            return this;
        }

        public final void setLastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
        }

        public final Instant getNextDeliveryTime() {
            return nextDeliveryTime;
        }

        @Override
        public final Builder nextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
            return this;
        }

        public final void setNextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
        }

        @Override
        public ConfigExportDeliveryInfo build() {
            return new ConfigExportDeliveryInfo(this);
        }
    }
}
