/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigurationRecorderStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of the configuration recorder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigurationRecorderStatus implements StructuredPojo,
        ToCopyableBuilder<ConfigurationRecorderStatus.Builder, ConfigurationRecorderStatus> {
    private final String name;

    private final Instant lastStartTime;

    private final Instant lastStopTime;

    private final Boolean recording;

    private final String lastStatus;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Instant lastStatusChangeTime;

    private ConfigurationRecorderStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.recording = builder.recording;
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    /**
     * <p>
     * The name of the configuration recorder.
     * </p>
     * 
     * @return The name of the configuration recorder.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The time the recorder was last started.
     * </p>
     * 
     * @return The time the recorder was last started.
     */
    public Instant lastStartTime() {
        return lastStartTime;
    }

    /**
     * <p>
     * The time the recorder was last stopped.
     * </p>
     * 
     * @return The time the recorder was last stopped.
     */
    public Instant lastStopTime() {
        return lastStopTime;
    }

    /**
     * <p>
     * Specifies whether the recorder is currently recording or not.
     * </p>
     * 
     * @return Specifies whether the recorder is currently recording or not.
     */
    public Boolean recording() {
        return recording;
    }

    /**
     * <p>
     * The last (previous) status of the recorder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link RecorderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusString}.
     * </p>
     * 
     * @return The last (previous) status of the recorder.
     * @see RecorderStatus
     */
    public RecorderStatus lastStatus() {
        return RecorderStatus.fromValue(lastStatus);
    }

    /**
     * <p>
     * The last (previous) status of the recorder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link RecorderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusString}.
     * </p>
     * 
     * @return The last (previous) status of the recorder.
     * @see RecorderStatus
     */
    public String lastStatusString() {
        return lastStatus;
    }

    /**
     * <p>
     * The error code indicating that the recording failed.
     * </p>
     * 
     * @return The error code indicating that the recording failed.
     */
    public String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The message indicating that the recording failed due to an error.
     * </p>
     * 
     * @return The message indicating that the recording failed due to an error.
     */
    public String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * The time when the status was last changed.
     * </p>
     * 
     * @return The time when the status was last changed.
     */
    public Instant lastStatusChangeTime() {
        return lastStatusChangeTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(recording());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChangeTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderStatus)) {
            return false;
        }
        ConfigurationRecorderStatus other = (ConfigurationRecorderStatus) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(lastStartTime(), other.lastStartTime())
                && Objects.equals(lastStopTime(), other.lastStopTime()) && Objects.equals(recording(), other.recording())
                && Objects.equals(lastStatusString(), other.lastStatusString())
                && Objects.equals(lastErrorCode(), other.lastErrorCode())
                && Objects.equals(lastErrorMessage(), other.lastErrorMessage())
                && Objects.equals(lastStatusChangeTime(), other.lastStatusChangeTime());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (lastStartTime() != null) {
            sb.append("LastStartTime: ").append(lastStartTime()).append(",");
        }
        if (lastStopTime() != null) {
            sb.append("LastStopTime: ").append(lastStopTime()).append(",");
        }
        if (recording() != null) {
            sb.append("Recording: ").append(recording()).append(",");
        }
        if (lastStatusString() != null) {
            sb.append("LastStatus: ").append(lastStatusString()).append(",");
        }
        if (lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(lastErrorCode()).append(",");
        }
        if (lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(lastErrorMessage()).append(",");
        }
        if (lastStatusChangeTime() != null) {
            sb.append("LastStatusChangeTime: ").append(lastStatusChangeTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "lastStartTime":
            return Optional.of(clazz.cast(lastStartTime()));
        case "lastStopTime":
            return Optional.of(clazz.cast(lastStopTime()));
        case "recording":
            return Optional.of(clazz.cast(recording()));
        case "lastStatus":
            return Optional.of(clazz.cast(lastStatusString()));
        case "lastErrorCode":
            return Optional.of(clazz.cast(lastErrorCode()));
        case "lastErrorMessage":
            return Optional.of(clazz.cast(lastErrorMessage()));
        case "lastStatusChangeTime":
            return Optional.of(clazz.cast(lastStatusChangeTime()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationRecorderStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigurationRecorderStatus> {
        /**
         * <p>
         * The name of the configuration recorder.
         * </p>
         * 
         * @param name
         *        The name of the configuration recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time the recorder was last started.
         * </p>
         * 
         * @param lastStartTime
         *        The time the recorder was last started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartTime(Instant lastStartTime);

        /**
         * <p>
         * The time the recorder was last stopped.
         * </p>
         * 
         * @param lastStopTime
         *        The time the recorder was last stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStopTime(Instant lastStopTime);

        /**
         * <p>
         * Specifies whether the recorder is currently recording or not.
         * </p>
         * 
         * @param recording
         *        Specifies whether the recorder is currently recording or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recording(Boolean recording);

        /**
         * <p>
         * The last (previous) status of the recorder.
         * </p>
         * 
         * @param lastStatus
         *        The last (previous) status of the recorder.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * The last (previous) status of the recorder.
         * </p>
         * 
         * @param lastStatus
         *        The last (previous) status of the recorder.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder lastStatus(RecorderStatus lastStatus);

        /**
         * <p>
         * The error code indicating that the recording failed.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code indicating that the recording failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The message indicating that the recording failed due to an error.
         * </p>
         * 
         * @param lastErrorMessage
         *        The message indicating that the recording failed due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * The time when the status was last changed.
         * </p>
         * 
         * @param lastStatusChangeTime
         *        The time when the status was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChangeTime(Instant lastStatusChangeTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Instant lastStartTime;

        private Instant lastStopTime;

        private Boolean recording;

        private String lastStatus;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderStatus model) {
            name(model.name);
            lastStartTime(model.lastStartTime);
            lastStopTime(model.lastStopTime);
            recording(model.recording);
            lastStatus(model.lastStatus);
            lastErrorCode(model.lastErrorCode);
            lastErrorMessage(model.lastErrorMessage);
            lastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getLastStartTime() {
            return lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        public final Instant getLastStopTime() {
            return lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        public final Boolean getRecording() {
            return recording;
        }

        @Override
        public final Builder recording(Boolean recording) {
            this.recording = recording;
            return this;
        }

        public final void setRecording(Boolean recording) {
            this.recording = recording;
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        @Override
        public ConfigurationRecorderStatus build() {
            return new ConfigurationRecorderStatus(this);
        }
    }
}
