/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DeliverConfigSnapshot</a> action in JSON format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeliverConfigSnapshotResponse extends ConfigResponse implements
        ToCopyableBuilder<DeliverConfigSnapshotResponse.Builder, DeliverConfigSnapshotResponse> {
    private final String configSnapshotId;

    private DeliverConfigSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.configSnapshotId = builder.configSnapshotId;
    }

    /**
     * <p>
     * The ID of the snapshot that is being created.
     * </p>
     * 
     * @return The ID of the snapshot that is being created.
     */
    public String configSnapshotId() {
        return configSnapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configSnapshotId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliverConfigSnapshotResponse)) {
            return false;
        }
        DeliverConfigSnapshotResponse other = (DeliverConfigSnapshotResponse) obj;
        return Objects.equals(configSnapshotId(), other.configSnapshotId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configSnapshotId() != null) {
            sb.append("ConfigSnapshotId: ").append(configSnapshotId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configSnapshotId":
            return Optional.of(clazz.cast(configSnapshotId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, DeliverConfigSnapshotResponse> {
        /**
         * <p>
         * The ID of the snapshot that is being created.
         * </p>
         * 
         * @param configSnapshotId
         *        The ID of the snapshot that is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configSnapshotId(String configSnapshotId);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String configSnapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliverConfigSnapshotResponse model) {
            configSnapshotId(model.configSnapshotId);
        }

        public final String getConfigSnapshotId() {
            return configSnapshotId;
        }

        @Override
        public final Builder configSnapshotId(String configSnapshotId) {
            this.configSnapshotId = configSnapshotId;
            return this;
        }

        public final void setConfigSnapshotId(String configSnapshotId) {
            this.configSnapshotId = configSnapshotId;
        }

        @Override
        public DeliverConfigSnapshotResponse build() {
            return new DeliverConfigSnapshotResponse(this);
        }
    }
}
