/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DescribeConfigurationRecorderStatus</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationRecorderStatusRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeConfigurationRecorderStatusRequest.Builder, DescribeConfigurationRecorderStatusRequest> {
    private final List<String> configurationRecorderNames;

    private DescribeConfigurationRecorderStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderNames = builder.configurationRecorderNames;
    }

    /**
     * <p>
     * The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of
     * all the configuration recorders associated with the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The name(s) of the configuration recorder. If the name is not specified, the action returns the current
     *         status of all the configuration recorders associated with the account.
     */
    public List<String> configurationRecorderNames() {
        return configurationRecorderNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationRecorderNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecorderStatusRequest)) {
            return false;
        }
        DescribeConfigurationRecorderStatusRequest other = (DescribeConfigurationRecorderStatusRequest) obj;
        return Objects.equals(configurationRecorderNames(), other.configurationRecorderNames());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configurationRecorderNames() != null) {
            sb.append("ConfigurationRecorderNames: ").append(configurationRecorderNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorderNames":
            return Optional.of(clazz.cast(configurationRecorderNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, DescribeConfigurationRecorderStatusRequest> {
        /**
         * <p>
         * The name(s) of the configuration recorder. If the name is not specified, the action returns the current
         * status of all the configuration recorders associated with the account.
         * </p>
         * 
         * @param configurationRecorderNames
         *        The name(s) of the configuration recorder. If the name is not specified, the action returns the
         *        current status of all the configuration recorders associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderNames(Collection<String> configurationRecorderNames);

        /**
         * <p>
         * The name(s) of the configuration recorder. If the name is not specified, the action returns the current
         * status of all the configuration recorders associated with the account.
         * </p>
         * 
         * @param configurationRecorderNames
         *        The name(s) of the configuration recorder. If the name is not specified, the action returns the
         *        current status of all the configuration recorders associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderNames(String... configurationRecorderNames);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> configurationRecorderNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecorderStatusRequest model) {
            configurationRecorderNames(model.configurationRecorderNames);
        }

        public final Collection<String> getConfigurationRecorderNames() {
            return configurationRecorderNames;
        }

        @Override
        public final Builder configurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderNames(String... configurationRecorderNames) {
            configurationRecorderNames(Arrays.asList(configurationRecorderNames));
            return this;
        }

        public final void setConfigurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationRecorderStatusRequest build() {
            return new DescribeConfigurationRecorderStatusRequest(this);
        }
    }
}
