/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeDeliveryChannelStatus</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDeliveryChannelStatusResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeDeliveryChannelStatusResponse.Builder, DescribeDeliveryChannelStatusResponse> {
    private final List<DeliveryChannelStatus> deliveryChannelsStatus;

    private DescribeDeliveryChannelStatusResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryChannelsStatus = builder.deliveryChannelsStatus;
    }

    /**
     * <p>
     * A list that contains the status of a specified delivery channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains the status of a specified delivery channel.
     */
    public List<DeliveryChannelStatus> deliveryChannelsStatus() {
        return deliveryChannelsStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryChannelsStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelStatusResponse)) {
            return false;
        }
        DescribeDeliveryChannelStatusResponse other = (DescribeDeliveryChannelStatusResponse) obj;
        return Objects.equals(deliveryChannelsStatus(), other.deliveryChannelsStatus());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryChannelsStatus() != null) {
            sb.append("DeliveryChannelsStatus: ").append(deliveryChannelsStatus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryChannelsStatus":
            return Optional.of(clazz.cast(deliveryChannelsStatus()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, DescribeDeliveryChannelStatusResponse> {
        /**
         * <p>
         * A list that contains the status of a specified delivery channel.
         * </p>
         * 
         * @param deliveryChannelsStatus
         *        A list that contains the status of a specified delivery channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelsStatus(Collection<DeliveryChannelStatus> deliveryChannelsStatus);

        /**
         * <p>
         * A list that contains the status of a specified delivery channel.
         * </p>
         * 
         * @param deliveryChannelsStatus
         *        A list that contains the status of a specified delivery channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelsStatus(DeliveryChannelStatus... deliveryChannelsStatus);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<DeliveryChannelStatus> deliveryChannelsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelStatusResponse model) {
            deliveryChannelsStatus(model.deliveryChannelsStatus);
        }

        public final Collection<DeliveryChannelStatus.Builder> getDeliveryChannelsStatus() {
            return deliveryChannelsStatus != null ? deliveryChannelsStatus.stream().map(DeliveryChannelStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deliveryChannelsStatus(Collection<DeliveryChannelStatus> deliveryChannelsStatus) {
            this.deliveryChannelsStatus = DeliveryChannelStatusListCopier.copy(deliveryChannelsStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannelsStatus(DeliveryChannelStatus... deliveryChannelsStatus) {
            deliveryChannelsStatus(Arrays.asList(deliveryChannelsStatus));
            return this;
        }

        public final void setDeliveryChannelsStatus(Collection<DeliveryChannelStatus.BuilderImpl> deliveryChannelsStatus) {
            this.deliveryChannelsStatus = DeliveryChannelStatusListCopier.copyFromBuilder(deliveryChannelsStatus);
        }

        @Override
        public DescribeDeliveryChannelStatusResponse build() {
            return new DescribeDeliveryChannelStatusResponse(this);
        }
    }
}
