/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.EvaluationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies an AWS resource and indicates whether it complies with the AWS Config rule that it was evaluated against.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Evaluation implements StructuredPojo, ToCopyableBuilder<Evaluation.Builder, Evaluation> {
    private final String complianceResourceType;

    private final String complianceResourceId;

    private final String complianceType;

    private final String annotation;

    private final Instant orderingTimestamp;

    private Evaluation(BuilderImpl builder) {
        this.complianceResourceType = builder.complianceResourceType;
        this.complianceResourceId = builder.complianceResourceId;
        this.complianceType = builder.complianceType;
        this.annotation = builder.annotation;
        this.orderingTimestamp = builder.orderingTimestamp;
    }

    /**
     * <p>
     * The type of AWS resource that was evaluated.
     * </p>
     * 
     * @return The type of AWS resource that was evaluated.
     */
    public String complianceResourceType() {
        return complianceResourceType;
    }

    /**
     * <p>
     * The ID of the AWS resource that was evaluated.
     * </p>
     * 
     * @return The ID of the AWS resource that was evaluated.
     */
    public String complianceResourceId() {
        return complianceResourceId;
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.
     * </p>
     * <p>
     * For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for this data type.
     * </p>
     * <p>
     * Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for <code>ComplianceType</code>
     * from a <code>PutEvaluations</code> request. For example, an AWS Lambda function for a custom Config rule cannot
     * pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeString}.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.</p>
     *         <p>
     *         For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for this data type.
     *         </p>
     *         <p>
     *         Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
     *         <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda
     *         function for a custom Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
     * @see ComplianceType
     */
    public ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.
     * </p>
     * <p>
     * For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for this data type.
     * </p>
     * <p>
     * Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for <code>ComplianceType</code>
     * from a <code>PutEvaluations</code> request. For example, an AWS Lambda function for a custom Config rule cannot
     * pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeString}.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.</p>
     *         <p>
     *         For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for this data type.
     *         </p>
     *         <p>
     *         Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
     *         <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda
     *         function for a custom Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
     * @see ComplianceType
     */
    public String complianceTypeString() {
        return complianceType;
    }

    /**
     * <p>
     * Supplementary information about how the evaluation determined the compliance.
     * </p>
     * 
     * @return Supplementary information about how the evaluation determined the compliance.
     */
    public String annotation() {
        return annotation;
    }

    /**
     * <p>
     * The time of the event in AWS Config that triggered the evaluation. For event-based evaluations, the time
     * indicates when AWS Config created the configuration item that triggered the evaluation. For periodic evaluations,
     * the time indicates when AWS Config triggered the evaluation at the frequency that you specified (for example,
     * every 24 hours).
     * </p>
     * 
     * @return The time of the event in AWS Config that triggered the evaluation. For event-based evaluations, the time
     *         indicates when AWS Config created the configuration item that triggered the evaluation. For periodic
     *         evaluations, the time indicates when AWS Config triggered the evaluation at the frequency that you
     *         specified (for example, every 24 hours).
     */
    public Instant orderingTimestamp() {
        return orderingTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(complianceResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(annotation());
        hashCode = 31 * hashCode + Objects.hashCode(orderingTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation) obj;
        return Objects.equals(complianceResourceType(), other.complianceResourceType())
                && Objects.equals(complianceResourceId(), other.complianceResourceId())
                && Objects.equals(complianceTypeString(), other.complianceTypeString())
                && Objects.equals(annotation(), other.annotation())
                && Objects.equals(orderingTimestamp(), other.orderingTimestamp());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (complianceResourceType() != null) {
            sb.append("ComplianceResourceType: ").append(complianceResourceType()).append(",");
        }
        if (complianceResourceId() != null) {
            sb.append("ComplianceResourceId: ").append(complianceResourceId()).append(",");
        }
        if (complianceTypeString() != null) {
            sb.append("ComplianceType: ").append(complianceTypeString()).append(",");
        }
        if (annotation() != null) {
            sb.append("Annotation: ").append(annotation()).append(",");
        }
        if (orderingTimestamp() != null) {
            sb.append("OrderingTimestamp: ").append(orderingTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceResourceType":
            return Optional.of(clazz.cast(complianceResourceType()));
        case "ComplianceResourceId":
            return Optional.of(clazz.cast(complianceResourceId()));
        case "ComplianceType":
            return Optional.of(clazz.cast(complianceTypeString()));
        case "Annotation":
            return Optional.of(clazz.cast(annotation()));
        case "OrderingTimestamp":
            return Optional.of(clazz.cast(orderingTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Evaluation> {
        /**
         * <p>
         * The type of AWS resource that was evaluated.
         * </p>
         * 
         * @param complianceResourceType
         *        The type of AWS resource that was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceType(String complianceResourceType);

        /**
         * <p>
         * The ID of the AWS resource that was evaluated.
         * </p>
         * 
         * @param complianceResourceId
         *        The ID of the AWS resource that was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceId(String complianceResourceId);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.
         * </p>
         * <p>
         * For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for this data type.
         * </p>
         * <p>
         * Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
         * <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda function
         * for a custom Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated
         *        against.</p>
         *        <p>
         *        For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for this data type.
         *        </p>
         *        <p>
         *        Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
         *        <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda
         *        function for a custom Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.
         * </p>
         * <p>
         * For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for this data type.
         * </p>
         * <p>
         * Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
         * <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda function
         * for a custom Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated
         *        against.</p>
         *        <p>
         *        For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for this data type.
         *        </p>
         *        <p>
         *        Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
         *        <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda
         *        function for a custom Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * Supplementary information about how the evaluation determined the compliance.
         * </p>
         * 
         * @param annotation
         *        Supplementary information about how the evaluation determined the compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotation(String annotation);

        /**
         * <p>
         * The time of the event in AWS Config that triggered the evaluation. For event-based evaluations, the time
         * indicates when AWS Config created the configuration item that triggered the evaluation. For periodic
         * evaluations, the time indicates when AWS Config triggered the evaluation at the frequency that you specified
         * (for example, every 24 hours).
         * </p>
         * 
         * @param orderingTimestamp
         *        The time of the event in AWS Config that triggered the evaluation. For event-based evaluations, the
         *        time indicates when AWS Config created the configuration item that triggered the evaluation. For
         *        periodic evaluations, the time indicates when AWS Config triggered the evaluation at the frequency
         *        that you specified (for example, every 24 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingTimestamp(Instant orderingTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String complianceResourceType;

        private String complianceResourceId;

        private String complianceType;

        private String annotation;

        private Instant orderingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Evaluation model) {
            complianceResourceType(model.complianceResourceType);
            complianceResourceId(model.complianceResourceId);
            complianceType(model.complianceType);
            annotation(model.annotation);
            orderingTimestamp(model.orderingTimestamp);
        }

        public final String getComplianceResourceType() {
            return complianceResourceType;
        }

        @Override
        public final Builder complianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
            return this;
        }

        public final void setComplianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
        }

        public final String getComplianceResourceId() {
            return complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getAnnotation() {
            return annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final Instant getOrderingTimestamp() {
            return orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        @Override
        public Evaluation build() {
            return new Evaluation(this);
        }
    }
}
