/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.EvaluationResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an AWS Config evaluation. Provides the AWS resource that was evaluated, the compliance of the
 * resource, related timestamps, and supplementary information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EvaluationResult implements StructuredPojo, ToCopyableBuilder<EvaluationResult.Builder, EvaluationResult> {
    private final EvaluationResultIdentifier evaluationResultIdentifier;

    private final String complianceType;

    private final Instant resultRecordedTime;

    private final Instant configRuleInvokedTime;

    private final String annotation;

    private final String resultToken;

    private EvaluationResult(BuilderImpl builder) {
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.complianceType = builder.complianceType;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.annotation = builder.annotation;
        this.resultToken = builder.resultToken;
    }

    /**
     * <p>
     * Uniquely identifies the evaluation result.
     * </p>
     * 
     * @return Uniquely identifies the evaluation result.
     */
    public EvaluationResultIdentifier evaluationResultIdentifier() {
        return evaluationResultIdentifier;
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.
     * </p>
     * <p>
     * For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeString}.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.</p>
     *         <p>
     *         For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * @see ComplianceType
     */
    public ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.
     * </p>
     * <p>
     * For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeString}.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.</p>
     *         <p>
     *         For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * @see ComplianceType
     */
    public String complianceTypeString() {
        return complianceType;
    }

    /**
     * <p>
     * The time when AWS Config recorded the evaluation result.
     * </p>
     * 
     * @return The time when AWS Config recorded the evaluation result.
     */
    public Instant resultRecordedTime() {
        return resultRecordedTime;
    }

    /**
     * <p>
     * The time when the AWS Config rule evaluated the AWS resource.
     * </p>
     * 
     * @return The time when the AWS Config rule evaluated the AWS resource.
     */
    public Instant configRuleInvokedTime() {
        return configRuleInvokedTime;
    }

    /**
     * <p>
     * Supplementary information about how the evaluation determined the compliance.
     * </p>
     * 
     * @return Supplementary information about how the evaluation determined the compliance.
     */
    public String annotation() {
        return annotation;
    }

    /**
     * <p>
     * An encrypted token that associates an evaluation with an AWS Config rule. The token identifies the rule, the AWS
     * resource being evaluated, and the event that triggered the evaluation.
     * </p>
     * 
     * @return An encrypted token that associates an evaluation with an AWS Config rule. The token identifies the rule,
     *         the AWS resource being evaluated, and the event that triggered the evaluation.
     */
    public String resultToken() {
        return resultToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResultIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(resultRecordedTime());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleInvokedTime());
        hashCode = 31 * hashCode + Objects.hashCode(annotation());
        hashCode = 31 * hashCode + Objects.hashCode(resultToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult) obj;
        return Objects.equals(evaluationResultIdentifier(), other.evaluationResultIdentifier())
                && Objects.equals(complianceTypeString(), other.complianceTypeString())
                && Objects.equals(resultRecordedTime(), other.resultRecordedTime())
                && Objects.equals(configRuleInvokedTime(), other.configRuleInvokedTime())
                && Objects.equals(annotation(), other.annotation()) && Objects.equals(resultToken(), other.resultToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (evaluationResultIdentifier() != null) {
            sb.append("EvaluationResultIdentifier: ").append(evaluationResultIdentifier()).append(",");
        }
        if (complianceTypeString() != null) {
            sb.append("ComplianceType: ").append(complianceTypeString()).append(",");
        }
        if (resultRecordedTime() != null) {
            sb.append("ResultRecordedTime: ").append(resultRecordedTime()).append(",");
        }
        if (configRuleInvokedTime() != null) {
            sb.append("ConfigRuleInvokedTime: ").append(configRuleInvokedTime()).append(",");
        }
        if (annotation() != null) {
            sb.append("Annotation: ").append(annotation()).append(",");
        }
        if (resultToken() != null) {
            sb.append("ResultToken: ").append(resultToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationResultIdentifier":
            return Optional.of(clazz.cast(evaluationResultIdentifier()));
        case "ComplianceType":
            return Optional.of(clazz.cast(complianceTypeString()));
        case "ResultRecordedTime":
            return Optional.of(clazz.cast(resultRecordedTime()));
        case "ConfigRuleInvokedTime":
            return Optional.of(clazz.cast(configRuleInvokedTime()));
        case "Annotation":
            return Optional.of(clazz.cast(annotation()));
        case "ResultToken":
            return Optional.of(clazz.cast(resultToken()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EvaluationResult> {
        /**
         * <p>
         * Uniquely identifies the evaluation result.
         * </p>
         * 
         * @param evaluationResultIdentifier
         *        Uniquely identifies the evaluation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier);

        /**
         * <p>
         * Uniquely identifies the evaluation result.
         * </p>
         * This is a convenience that creates an instance of the {@link EvaluationResultIdentifier.Builder} avoiding the
         * need to create one manually via {@link EvaluationResultIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link EvaluationResultIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluationResultIdentifier(EvaluationResultIdentifier)}.
         * 
         * @param evaluationResultIdentifier
         *        a consumer that will call methods on {@link EvaluationResultIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResultIdentifier(EvaluationResultIdentifier)
         */
        default Builder evaluationResultIdentifier(Consumer<EvaluationResultIdentifier.Builder> evaluationResultIdentifier) {
            return evaluationResultIdentifier(EvaluationResultIdentifier.builder().apply(evaluationResultIdentifier).build());
        }

        /**
         * <p>
         * Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.
         * </p>
         * <p>
         * For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.</p>
         *        <p>
         *        For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.
         * </p>
         * <p>
         * For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.</p>
         *        <p>
         *        For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * The time when AWS Config recorded the evaluation result.
         * </p>
         * 
         * @param resultRecordedTime
         *        The time when AWS Config recorded the evaluation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultRecordedTime(Instant resultRecordedTime);

        /**
         * <p>
         * The time when the AWS Config rule evaluated the AWS resource.
         * </p>
         * 
         * @param configRuleInvokedTime
         *        The time when the AWS Config rule evaluated the AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleInvokedTime(Instant configRuleInvokedTime);

        /**
         * <p>
         * Supplementary information about how the evaluation determined the compliance.
         * </p>
         * 
         * @param annotation
         *        Supplementary information about how the evaluation determined the compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotation(String annotation);

        /**
         * <p>
         * An encrypted token that associates an evaluation with an AWS Config rule. The token identifies the rule, the
         * AWS resource being evaluated, and the event that triggered the evaluation.
         * </p>
         * 
         * @param resultToken
         *        An encrypted token that associates an evaluation with an AWS Config rule. The token identifies the
         *        rule, the AWS resource being evaluated, and the event that triggered the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultToken(String resultToken);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationResultIdentifier evaluationResultIdentifier;

        private String complianceType;

        private Instant resultRecordedTime;

        private Instant configRuleInvokedTime;

        private String annotation;

        private String resultToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            evaluationResultIdentifier(model.evaluationResultIdentifier);
            complianceType(model.complianceType);
            resultRecordedTime(model.resultRecordedTime);
            configRuleInvokedTime(model.configRuleInvokedTime);
            annotation(model.annotation);
            resultToken(model.resultToken);
        }

        public final EvaluationResultIdentifier.Builder getEvaluationResultIdentifier() {
            return evaluationResultIdentifier != null ? evaluationResultIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier.BuilderImpl evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier != null ? evaluationResultIdentifier.build() : null;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Instant getResultRecordedTime() {
            return resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        public final Instant getConfigRuleInvokedTime() {
            return configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        public final String getAnnotation() {
            return annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final String getResultToken() {
            return resultToken;
        }

        @Override
        public final Builder resultToken(String resultToken) {
            this.resultToken = resultToken;
            return this;
        }

        public final void setResultToken(String resultToken) {
            this.resultToken = resultToken;
        }

        @Override
        public EvaluationResult build() {
            return new EvaluationResult(this);
        }
    }
}
