/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetComplianceDetailsByResourceResponse extends ConfigResponse implements
        ToCopyableBuilder<GetComplianceDetailsByResourceResponse.Builder, GetComplianceDetailsByResourceResponse> {
    private final List<EvaluationResult> evaluationResults;

    private final String nextToken;

    private GetComplianceDetailsByResourceResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResults = builder.evaluationResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Indicates whether the specified AWS resource complies each AWS Config rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Indicates whether the specified AWS resource complies each AWS Config rule.
     */
    public List<EvaluationResult> evaluationResults() {
        return evaluationResults;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByResourceResponse)) {
            return false;
        }
        GetComplianceDetailsByResourceResponse other = (GetComplianceDetailsByResourceResponse) obj;
        return Objects.equals(evaluationResults(), other.evaluationResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (evaluationResults() != null) {
            sb.append("EvaluationResults: ").append(evaluationResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationResults":
            return Optional.of(clazz.cast(evaluationResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, GetComplianceDetailsByResourceResponse> {
        /**
         * <p>
         * Indicates whether the specified AWS resource complies each AWS Config rule.
         * </p>
         * 
         * @param evaluationResults
         *        Indicates whether the specified AWS resource complies each AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResults(Collection<EvaluationResult> evaluationResults);

        /**
         * <p>
         * Indicates whether the specified AWS resource complies each AWS Config rule.
         * </p>
         * 
         * @param evaluationResults
         *        Indicates whether the specified AWS resource complies each AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResults(EvaluationResult... evaluationResults);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<EvaluationResult> evaluationResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByResourceResponse model) {
            evaluationResults(model.evaluationResults);
            nextToken(model.nextToken);
        }

        public final Collection<EvaluationResult.Builder> getEvaluationResults() {
            return evaluationResults != null ? evaluationResults.stream().map(EvaluationResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult... evaluationResults) {
            evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        public final void setEvaluationResults(Collection<EvaluationResult.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copyFromBuilder(evaluationResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetComplianceDetailsByResourceResponse build() {
            return new GetComplianceDetailsByResourceResponse(this);
        }
    }
}
