/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class StartConfigRulesEvaluationRequest extends ConfigRequest implements
        ToCopyableBuilder<StartConfigRulesEvaluationRequest.Builder, StartConfigRulesEvaluationRequest> {
    private final List<String> configRuleNames;

    private StartConfigRulesEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleNames = builder.configRuleNames;
    }

    /**
     * <p>
     * The list of names of Config rules that you want to run evaluations for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of names of Config rules that you want to run evaluations for.
     */
    public List<String> configRuleNames() {
        return configRuleNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigRulesEvaluationRequest)) {
            return false;
        }
        StartConfigRulesEvaluationRequest other = (StartConfigRulesEvaluationRequest) obj;
        return Objects.equals(configRuleNames(), other.configRuleNames());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configRuleNames() != null) {
            sb.append("ConfigRuleNames: ").append(configRuleNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleNames":
            return Optional.of(clazz.cast(configRuleNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, StartConfigRulesEvaluationRequest> {
        /**
         * <p>
         * The list of names of Config rules that you want to run evaluations for.
         * </p>
         * 
         * @param configRuleNames
         *        The list of names of Config rules that you want to run evaluations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * The list of names of Config rules that you want to run evaluations for.
         * </p>
         * 
         * @param configRuleNames
         *        The list of names of Config rules that you want to run evaluations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> configRuleNames;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigRulesEvaluationRequest model) {
            configRuleNames(model.configRuleNames);
        }

        public final Collection<String> getConfigRuleNames() {
            return configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ReevaluateConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ReevaluateConfigRuleNamesCopier.copy(configRuleNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartConfigRulesEvaluationRequest build() {
            return new StartConfigRulesEvaluationRequest(this);
        }
    }
}
