/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>StopConfigurationRecorder</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StopConfigurationRecorderRequest extends ConfigRequest implements
        ToCopyableBuilder<StopConfigurationRecorderRequest.Builder, StopConfigurationRecorderRequest> {
    private final String configurationRecorderName;

    private StopConfigurationRecorderRequest(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderName = builder.configurationRecorderName;
    }

    /**
     * <p>
     * The name of the recorder object that records each configuration change made to the resources.
     * </p>
     * 
     * @return The name of the recorder object that records each configuration change made to the resources.
     */
    public String configurationRecorderName() {
        return configurationRecorderName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationRecorderName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopConfigurationRecorderRequest)) {
            return false;
        }
        StopConfigurationRecorderRequest other = (StopConfigurationRecorderRequest) obj;
        return Objects.equals(configurationRecorderName(), other.configurationRecorderName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configurationRecorderName() != null) {
            sb.append("ConfigurationRecorderName: ").append(configurationRecorderName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorderName":
            return Optional.of(clazz.cast(configurationRecorderName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, StopConfigurationRecorderRequest> {
        /**
         * <p>
         * The name of the recorder object that records each configuration change made to the resources.
         * </p>
         * 
         * @param configurationRecorderName
         *        The name of the recorder object that records each configuration change made to the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderName(String configurationRecorderName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationRecorderName;

        private BuilderImpl() {
        }

        private BuilderImpl(StopConfigurationRecorderRequest model) {
            configurationRecorderName(model.configurationRecorderName);
        }

        public final String getConfigurationRecorderName() {
            return configurationRecorderName;
        }

        @Override
        public final Builder configurationRecorderName(String configurationRecorderName) {
            this.configurationRecorderName = configurationRecorderName;
            return this;
        }

        public final void setConfigurationRecorderName(String configurationRecorderName) {
            this.configurationRecorderName = configurationRecorderName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StopConfigurationRecorderRequest build() {
            return new StopConfigurationRecorderRequest(this);
        }
    }
}
