/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.EvaluationResultQualifier;
import software.amazon.awssdk.services.config.transform.EvaluationResultIdentifierMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EvaluationResultIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, EvaluationResultIdentifier> {
    private final EvaluationResultQualifier evaluationResultQualifier;
    private final Instant orderingTimestamp;

    private EvaluationResultIdentifier(BuilderImpl builder) {
        this.evaluationResultQualifier = builder.evaluationResultQualifier;
        this.orderingTimestamp = builder.orderingTimestamp;
    }

    public EvaluationResultQualifier evaluationResultQualifier() {
        return this.evaluationResultQualifier;
    }

    public Instant orderingTimestamp() {
        return this.orderingTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResultQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderingTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResultIdentifier)) {
            return false;
        }
        EvaluationResultIdentifier other = (EvaluationResultIdentifier)obj;
        return Objects.equals(this.evaluationResultQualifier(), other.evaluationResultQualifier()) && Objects.equals(this.orderingTimestamp(), other.orderingTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.evaluationResultQualifier() != null) {
            sb.append("EvaluationResultQualifier: ").append(this.evaluationResultQualifier()).append(",");
        }
        if (this.orderingTimestamp() != null) {
            sb.append("OrderingTimestamp: ").append(this.orderingTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationResultQualifier": {
                return Optional.of(clazz.cast(this.evaluationResultQualifier()));
            }
            case "OrderingTimestamp": {
                return Optional.of(clazz.cast(this.orderingTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationResultQualifier evaluationResultQualifier;
        private Instant orderingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResultIdentifier model) {
            this.evaluationResultQualifier(model.evaluationResultQualifier);
            this.orderingTimestamp(model.orderingTimestamp);
        }

        public final EvaluationResultQualifier.Builder getEvaluationResultQualifier() {
            return this.evaluationResultQualifier != null ? this.evaluationResultQualifier.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResultQualifier(EvaluationResultQualifier evaluationResultQualifier) {
            this.evaluationResultQualifier = evaluationResultQualifier;
            return this;
        }

        public final void setEvaluationResultQualifier(EvaluationResultQualifier.BuilderImpl evaluationResultQualifier) {
            this.evaluationResultQualifier = evaluationResultQualifier != null ? evaluationResultQualifier.build() : null;
        }

        public final Instant getOrderingTimestamp() {
            return this.orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        public EvaluationResultIdentifier build() {
            return new EvaluationResultIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EvaluationResultIdentifier> {
        public Builder evaluationResultQualifier(EvaluationResultQualifier var1);

        default public Builder evaluationResultQualifier(Consumer<EvaluationResultQualifier.Builder> evaluationResultQualifier) {
            return this.evaluationResultQualifier((EvaluationResultQualifier)((EvaluationResultQualifier.Builder)EvaluationResultQualifier.builder().apply(evaluationResultQualifier)).build());
        }

        public Builder orderingTimestamp(Instant var1);
    }
}

