/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.services.config.model.EvaluationResultsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetComplianceDetailsByConfigRuleResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetComplianceDetailsByConfigRuleResponse> {
    private final List<EvaluationResult> evaluationResults;
    private final String nextToken;

    private GetComplianceDetailsByConfigRuleResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResults = builder.evaluationResults;
        this.nextToken = builder.nextToken;
    }

    public List<EvaluationResult> evaluationResults() {
        return this.evaluationResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByConfigRuleResponse)) {
            return false;
        }
        GetComplianceDetailsByConfigRuleResponse other = (GetComplianceDetailsByConfigRuleResponse)((Object)obj);
        return Objects.equals(this.evaluationResults(), other.evaluationResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.evaluationResults() != null) {
            sb.append("EvaluationResults: ").append(this.evaluationResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationResults": {
                return Optional.of(clazz.cast(this.evaluationResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<EvaluationResult> evaluationResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByConfigRuleResponse model) {
            this.evaluationResults(model.evaluationResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<EvaluationResult.Builder> getEvaluationResults() {
            return this.evaluationResults != null ? (Collection)this.evaluationResults.stream().map(EvaluationResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult ... evaluationResults) {
            this.evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        public final void setEvaluationResults(Collection<EvaluationResult.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copyFromBuilder(evaluationResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetComplianceDetailsByConfigRuleResponse build() {
            return new GetComplianceDetailsByConfigRuleResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, GetComplianceDetailsByConfigRuleResponse> {
        public Builder evaluationResults(Collection<EvaluationResult> var1);

        public Builder evaluationResults(EvaluationResult ... var1);

        public Builder nextToken(String var1);
    }
}

