/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigurationRecorderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the recording of configuration changes of an AWS resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigurationRecorder implements StructuredPojo,
        ToCopyableBuilder<ConfigurationRecorder.Builder, ConfigurationRecorder> {
    private final String name;

    private final String roleARN;

    private final RecordingGroup recordingGroup;

    private ConfigurationRecorder(BuilderImpl builder) {
        this.name = builder.name;
        this.roleARN = builder.roleARN;
        this.recordingGroup = builder.recordingGroup;
    }

    /**
     * <p>
     * The name of the recorder. By default, AWS Config automatically assigns the name "default" when creating the
     * configuration recorder. You cannot change the assigned name.
     * </p>
     * 
     * @return The name of the recorder. By default, AWS Config automatically assigns the name "default" when creating
     *         the configuration recorder. You cannot change the assigned name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources associated with the account.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources associated with the
     *         account.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Specifies the types of AWS resource for which AWS Config records configuration changes.
     * </p>
     * 
     * @return Specifies the types of AWS resource for which AWS Config records configuration changes.
     */
    public RecordingGroup recordingGroup() {
        return recordingGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(recordingGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorder)) {
            return false;
        }
        ConfigurationRecorder other = (ConfigurationRecorder) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(recordingGroup(), other.recordingGroup());
    }

    @Override
    public String toString() {
        return ToString.builder("ConfigurationRecorder").add("Name", name()).add("RoleARN", roleARN())
                .add("RecordingGroup", recordingGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "roleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "recordingGroup":
            return Optional.of(clazz.cast(recordingGroup()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationRecorderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigurationRecorder> {
        /**
         * <p>
         * The name of the recorder. By default, AWS Config automatically assigns the name "default" when creating the
         * configuration recorder. You cannot change the assigned name.
         * </p>
         * 
         * @param name
         *        The name of the recorder. By default, AWS Config automatically assigns the name "default" when
         *        creating the configuration recorder. You cannot change the assigned name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources associated with the account.
         * </p>
         * 
         * @param roleARN
         *        Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources associated with the
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Specifies the types of AWS resource for which AWS Config records configuration changes.
         * </p>
         * 
         * @param recordingGroup
         *        Specifies the types of AWS resource for which AWS Config records configuration changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingGroup(RecordingGroup recordingGroup);

        /**
         * <p>
         * Specifies the types of AWS resource for which AWS Config records configuration changes.
         * </p>
         * This is a convenience that creates an instance of the {@link RecordingGroup.Builder} avoiding the need to
         * create one manually via {@link RecordingGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecordingGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #recordingGroup(RecordingGroup)}.
         * 
         * @param recordingGroup
         *        a consumer that will call methods on {@link RecordingGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordingGroup(RecordingGroup)
         */
        default Builder recordingGroup(Consumer<RecordingGroup.Builder> recordingGroup) {
            return recordingGroup(RecordingGroup.builder().apply(recordingGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String roleARN;

        private RecordingGroup recordingGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorder model) {
            name(model.name);
            roleARN(model.roleARN);
            recordingGroup(model.recordingGroup);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final RecordingGroup.Builder getRecordingGroup() {
            return recordingGroup != null ? recordingGroup.toBuilder() : null;
        }

        @Override
        public final Builder recordingGroup(RecordingGroup recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        public final void setRecordingGroup(RecordingGroup.BuilderImpl recordingGroup) {
            this.recordingGroup = recordingGroup != null ? recordingGroup.build() : null;
        }

        @Override
        public ConfigurationRecorder build() {
            return new ConfigurationRecorder(this);
        }
    }
}
