/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output when you delete the evaluation results for the specified Config rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteEvaluationResultsResponse extends ConfigResponse implements
        ToCopyableBuilder<DeleteEvaluationResultsResponse.Builder, DeleteEvaluationResultsResponse> {
    private DeleteEvaluationResultsResponse(BuilderImpl builder) {
        super(builder);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEvaluationResultsResponse)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteEvaluationResultsResponse").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        return Optional.empty();
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, DeleteEvaluationResultsResponse> {
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEvaluationResultsResponse model) {
        }

        @Override
        public DeleteEvaluationResultsResponse build() {
            return new DeleteEvaluationResultsResponse(this);
        }
    }
}
