/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.config.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * DeliveryChannelStatusMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class DeliveryChannelStatusMarshaller {

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> CONFIGSNAPSHOTDELIVERYINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("configSnapshotDeliveryInfo").build();
    private static final MarshallingInfo<StructuredPojo> CONFIGHISTORYDELIVERYINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("configHistoryDeliveryInfo").build();
    private static final MarshallingInfo<StructuredPojo> CONFIGSTREAMDELIVERYINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("configStreamDeliveryInfo").build();

    private static final DeliveryChannelStatusMarshaller INSTANCE = new DeliveryChannelStatusMarshaller();

    public static DeliveryChannelStatusMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DeliveryChannelStatus deliveryChannelStatus, ProtocolMarshaller protocolMarshaller) {

        if (deliveryChannelStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(deliveryChannelStatus.name(), NAME_BINDING);

            protocolMarshaller.marshall(deliveryChannelStatus.configSnapshotDeliveryInfo(), CONFIGSNAPSHOTDELIVERYINFO_BINDING);

            protocolMarshaller.marshall(deliveryChannelStatus.configHistoryDeliveryInfo(), CONFIGHISTORYDELIVERYINFO_BINDING);

            protocolMarshaller.marshall(deliveryChannelStatus.configStreamDeliveryInfo(), CONFIGSTREAMDELIVERYINFO_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
