/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteConfigRuleRequest extends ConfigRequest implements
        ToCopyableBuilder<DeleteConfigRuleRequest.Builder, DeleteConfigRuleRequest> {
    private final String configRuleName;

    private DeleteConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
    }

    /**
     * <p>
     * The name of the AWS Config rule that you want to delete.
     * </p>
     * 
     * @return The name of the AWS Config rule that you want to delete.
     */
    public String configRuleName() {
        return configRuleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigRuleRequest)) {
            return false;
        }
        DeleteConfigRuleRequest other = (DeleteConfigRuleRequest) obj;
        return Objects.equals(configRuleName(), other.configRuleName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteConfigRuleRequest").add("ConfigRuleName", configRuleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.of(clazz.cast(configRuleName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigRequest.Builder, CopyableBuilder<Builder, DeleteConfigRuleRequest> {
        /**
         * <p>
         * The name of the AWS Config rule that you want to delete.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configRuleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigRuleRequest model) {
            configRuleName(model.configRuleName);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteConfigRuleRequest build() {
            return new DeleteConfigRuleRequest(this);
        }
    }
}
