/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeDeliveryChannels</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDeliveryChannelsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeDeliveryChannelsResponse.Builder, DescribeDeliveryChannelsResponse> {
    private final List<DeliveryChannel> deliveryChannels;

    private DescribeDeliveryChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryChannels = builder.deliveryChannels;
    }

    /**
     * <p>
     * A list that contains the descriptions of the specified delivery channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains the descriptions of the specified delivery channel.
     */
    public List<DeliveryChannel> deliveryChannels() {
        return deliveryChannels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryChannels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelsResponse)) {
            return false;
        }
        DescribeDeliveryChannelsResponse other = (DescribeDeliveryChannelsResponse) obj;
        return Objects.equals(deliveryChannels(), other.deliveryChannels());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDeliveryChannelsResponse").add("DeliveryChannels", deliveryChannels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryChannels":
            return Optional.of(clazz.cast(deliveryChannels()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ConfigResponse.Builder, CopyableBuilder<Builder, DescribeDeliveryChannelsResponse> {
        /**
         * <p>
         * A list that contains the descriptions of the specified delivery channel.
         * </p>
         * 
         * @param deliveryChannels
         *        A list that contains the descriptions of the specified delivery channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannels(Collection<DeliveryChannel> deliveryChannels);

        /**
         * <p>
         * A list that contains the descriptions of the specified delivery channel.
         * </p>
         * 
         * @param deliveryChannels
         *        A list that contains the descriptions of the specified delivery channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannels(DeliveryChannel... deliveryChannels);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<DeliveryChannel> deliveryChannels;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelsResponse model) {
            deliveryChannels(model.deliveryChannels);
        }

        public final Collection<DeliveryChannel.Builder> getDeliveryChannels() {
            return deliveryChannels != null ? deliveryChannels.stream().map(DeliveryChannel::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deliveryChannels(Collection<DeliveryChannel> deliveryChannels) {
            this.deliveryChannels = DeliveryChannelListCopier.copy(deliveryChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannels(DeliveryChannel... deliveryChannels) {
            deliveryChannels(Arrays.asList(deliveryChannels));
            return this;
        }

        public final void setDeliveryChannels(Collection<DeliveryChannel.BuilderImpl> deliveryChannels) {
            this.deliveryChannels = DeliveryChannelListCopier.copyFromBuilder(deliveryChannels);
        }

        @Override
        public DescribeDeliveryChannelsResponse build() {
            return new DescribeDeliveryChannelsResponse(this);
        }
    }
}
