/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.SourceDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the source and the message types that trigger AWS Config to evaluate your AWS resources against a rule. It
 * also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is
 * periodic. You can specify the parameter values for <code>SourceDetail</code> only for custom rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SourceDetail implements StructuredPojo, ToCopyableBuilder<SourceDetail.Builder, SourceDetail> {
    private final String eventSource;

    private final String messageType;

    private final String maximumExecutionFrequency;

    private SourceDetail(BuilderImpl builder) {
        this.eventSource = builder.eventSource;
        this.messageType = builder.messageType;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
    }

    /**
     * <p>
     * The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSource} will
     * return {@link EventSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventSourceString}.
     * </p>
     * 
     * @return The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources.
     * @see EventSource
     */
    public EventSource eventSource() {
        return EventSource.fromValue(eventSource);
    }

    /**
     * <p>
     * The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSource} will
     * return {@link EventSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventSourceString}.
     * </p>
     * 
     * @return The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources.
     * @see EventSource
     */
    public String eventSourceString() {
        return eventSource;
    }

    /**
     * <p>
     * The type of notification that triggers AWS Config to run an evaluation for a rule. You can specify the following
     * notification types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a
     * configuration item as a result of a resource change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an
     * oversized configuration item. AWS Config may generate this notification type when a resource changes and the
     * notification exceeds the maximum size allowed by Amazon SNS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
     * <code>MaximumExecutionFrequency</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config delivers a
     * configuration snapshot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want your custom rule to be triggered by configuration changes, specify both
     * <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeString}.
     * </p>
     * 
     * @return The type of notification that triggers AWS Config to run an evaluation for a rule. You can specify the
     *         following notification types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a
     *         configuration item as a result of a resource change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config
     *         delivers an oversized configuration item. AWS Config may generate this notification type when a resource
     *         changes and the notification exceeds the maximum size allowed by Amazon SNS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
     *         <code>MaximumExecutionFrequency</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config
     *         delivers a configuration snapshot.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want your custom rule to be triggered by configuration changes, specify both
     *         <code>ConfigurationItemChangeNotification</code> and
     *         <code>OversizedConfigurationItemChangeNotification</code>.
     * @see MessageType
     */
    public MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The type of notification that triggers AWS Config to run an evaluation for a rule. You can specify the following
     * notification types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a
     * configuration item as a result of a resource change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an
     * oversized configuration item. AWS Config may generate this notification type when a resource changes and the
     * notification exceeds the maximum size allowed by Amazon SNS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
     * <code>MaximumExecutionFrequency</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config delivers a
     * configuration snapshot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want your custom rule to be triggered by configuration changes, specify both
     * <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeString}.
     * </p>
     * 
     * @return The type of notification that triggers AWS Config to run an evaluation for a rule. You can specify the
     *         following notification types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a
     *         configuration item as a result of a resource change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config
     *         delivers an oversized configuration item. AWS Config may generate this notification type when a resource
     *         changes and the notification exceeds the maximum size allowed by Amazon SNS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
     *         <code>MaximumExecutionFrequency</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config
     *         delivers a configuration snapshot.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want your custom rule to be triggered by configuration changes, specify both
     *         <code>ConfigurationItemChangeNotification</code> and
     *         <code>OversizedConfigurationItemChangeNotification</code>.
     * @see MessageType
     */
    public String messageTypeString() {
        return messageType;
    }

    /**
     * <p>
     * The frequency that you want AWS Config to run evaluations for a custom rule with a periodic trigger. If you
     * specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the
     * <code>ScheduledNotification</code> value.
     * </p>
     * <note>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
     * value for the <code>MaximumExecutionFrequency</code> parameter.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumExecutionFrequency} will return {@link MaximumExecutionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumExecutionFrequencyString}.
     * </p>
     * 
     * @return The frequency that you want AWS Config to run evaluations for a custom rule with a periodic trigger. If
     *         you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use
     *         the <code>ScheduledNotification</code> value.</p> <note>
     *         <p>
     *         By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify
     *         a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     *         </p>
     * @see MaximumExecutionFrequency
     */
    public MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(maximumExecutionFrequency);
    }

    /**
     * <p>
     * The frequency that you want AWS Config to run evaluations for a custom rule with a periodic trigger. If you
     * specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the
     * <code>ScheduledNotification</code> value.
     * </p>
     * <note>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
     * value for the <code>MaximumExecutionFrequency</code> parameter.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumExecutionFrequency} will return {@link MaximumExecutionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumExecutionFrequencyString}.
     * </p>
     * 
     * @return The frequency that you want AWS Config to run evaluations for a custom rule with a periodic trigger. If
     *         you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use
     *         the <code>ScheduledNotification</code> value.</p> <note>
     *         <p>
     *         By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify
     *         a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     *         </p>
     * @see MaximumExecutionFrequency
     */
    public String maximumExecutionFrequencyString() {
        return maximumExecutionFrequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceString());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumExecutionFrequencyString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDetail)) {
            return false;
        }
        SourceDetail other = (SourceDetail) obj;
        return Objects.equals(eventSourceString(), other.eventSourceString())
                && Objects.equals(messageTypeString(), other.messageTypeString())
                && Objects.equals(maximumExecutionFrequencyString(), other.maximumExecutionFrequencyString());
    }

    @Override
    public String toString() {
        return ToString.builder("SourceDetail").add("EventSource", eventSourceString()).add("MessageType", messageTypeString())
                .add("MaximumExecutionFrequency", maximumExecutionFrequencyString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSource":
            return Optional.of(clazz.cast(eventSourceString()));
        case "MessageType":
            return Optional.of(clazz.cast(messageTypeString()));
        case "MaximumExecutionFrequency":
            return Optional.of(clazz.cast(maximumExecutionFrequencyString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SourceDetail> {
        /**
         * <p>
         * The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources.
         * </p>
         * 
         * @param eventSource
         *        The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS
         *        resources.
         * @see EventSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSource
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources.
         * </p>
         * 
         * @param eventSource
         *        The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS
         *        resources.
         * @see EventSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSource
         */
        Builder eventSource(EventSource eventSource);

        /**
         * <p>
         * The type of notification that triggers AWS Config to run an evaluation for a rule. You can specify the
         * following notification types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a
         * configuration item as a result of a resource change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers
         * an oversized configuration item. AWS Config may generate this notification type when a resource changes and
         * the notification exceeds the maximum size allowed by Amazon SNS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
         * <code>MaximumExecutionFrequency</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config delivers
         * a configuration snapshot.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want your custom rule to be triggered by configuration changes, specify both
         * <code>ConfigurationItemChangeNotification</code> and
         * <code>OversizedConfigurationItemChangeNotification</code>.
         * </p>
         * 
         * @param messageType
         *        The type of notification that triggers AWS Config to run an evaluation for a rule. You can specify the
         *        following notification types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a
         *        configuration item as a result of a resource change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config
         *        delivers an oversized configuration item. AWS Config may generate this notification type when a
         *        resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
         *        <code>MaximumExecutionFrequency</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config
         *        delivers a configuration snapshot.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want your custom rule to be triggered by configuration changes, specify both
         *        <code>ConfigurationItemChangeNotification</code> and
         *        <code>OversizedConfigurationItemChangeNotification</code>.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The type of notification that triggers AWS Config to run an evaluation for a rule. You can specify the
         * following notification types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a
         * configuration item as a result of a resource change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers
         * an oversized configuration item. AWS Config may generate this notification type when a resource changes and
         * the notification exceeds the maximum size allowed by Amazon SNS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
         * <code>MaximumExecutionFrequency</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config delivers
         * a configuration snapshot.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want your custom rule to be triggered by configuration changes, specify both
         * <code>ConfigurationItemChangeNotification</code> and
         * <code>OversizedConfigurationItemChangeNotification</code>.
         * </p>
         * 
         * @param messageType
         *        The type of notification that triggers AWS Config to run an evaluation for a rule. You can specify the
         *        following notification types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a
         *        configuration item as a result of a resource change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config
         *        delivers an oversized configuration item. AWS Config may generate this notification type when a
         *        resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for
         *        <code>MaximumExecutionFrequency</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config
         *        delivers a configuration snapshot.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want your custom rule to be triggered by configuration changes, specify both
         *        <code>ConfigurationItemChangeNotification</code> and
         *        <code>OversizedConfigurationItemChangeNotification</code>.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * The frequency that you want AWS Config to run evaluations for a custom rule with a periodic trigger. If you
         * specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the
         * <code>ScheduledNotification</code> value.
         * </p>
         * <note>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a
         * valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * </p>
         * </note>
         * 
         * @param maximumExecutionFrequency
         *        The frequency that you want AWS Config to run evaluations for a custom rule with a periodic trigger.
         *        If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must
         *        use the <code>ScheduledNotification</code> value.</p> <note>
         *        <p>
         *        By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency,
         *        specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         *        </p>
         * @see MaximumExecutionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumExecutionFrequency
         */
        Builder maximumExecutionFrequency(String maximumExecutionFrequency);

        /**
         * <p>
         * The frequency that you want AWS Config to run evaluations for a custom rule with a periodic trigger. If you
         * specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the
         * <code>ScheduledNotification</code> value.
         * </p>
         * <note>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a
         * valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * </p>
         * </note>
         * 
         * @param maximumExecutionFrequency
         *        The frequency that you want AWS Config to run evaluations for a custom rule with a periodic trigger.
         *        If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must
         *        use the <code>ScheduledNotification</code> value.</p> <note>
         *        <p>
         *        By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency,
         *        specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         *        </p>
         * @see MaximumExecutionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumExecutionFrequency
         */
        Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency);
    }

    static final class BuilderImpl implements Builder {
        private String eventSource;

        private String messageType;

        private String maximumExecutionFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDetail model) {
            eventSource(model.eventSource);
            messageType(model.messageType);
            maximumExecutionFrequency(model.maximumExecutionFrequency);
        }

        public final String getEventSource() {
            return eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSource eventSource) {
            this.eventSource(eventSource.toString());
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getMessageType() {
            return messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getMaximumExecutionFrequency() {
            return maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        @Override
        public SourceDetail build() {
            return new SourceDetail(this);
        }
    }
}
