/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ConfigExportDeliveryInfo} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ConfigExportDeliveryInfoMarshaller {
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").isBinary(false).build();

    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorCode").isBinary(false).build();

    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorMessage").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTATTEMPTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastAttemptTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSUCCESSFULTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastSuccessfulTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> NEXTDELIVERYTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextDeliveryTime").isBinary(false).build();

    private static final ConfigExportDeliveryInfoMarshaller INSTANCE = new ConfigExportDeliveryInfoMarshaller();

    private ConfigExportDeliveryInfoMarshaller() {
    }

    public static ConfigExportDeliveryInfoMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ConfigExportDeliveryInfo configExportDeliveryInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(configExportDeliveryInfo, "configExportDeliveryInfo");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(configExportDeliveryInfo.lastStatusString(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall(configExportDeliveryInfo.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall(configExportDeliveryInfo.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(configExportDeliveryInfo.lastAttemptTime(), LASTATTEMPTTIME_BINDING);
            protocolMarshaller.marshall(configExportDeliveryInfo.lastSuccessfulTime(), LASTSUCCESSFULTIME_BINDING);
            protocolMarshaller.marshall(configExportDeliveryInfo.nextDeliveryTime(), NEXTDELIVERYTIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
