/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ConfigurationRecorderStatus} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ConfigurationRecorderStatusMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSTARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStartTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSTOPTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStopTime").isBinary(false).build();

    private static final MarshallingInfo<Boolean> RECORDING_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recording").isBinary(false).build();

    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").isBinary(false).build();

    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorCode").isBinary(false).build();

    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorMessage").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSTATUSCHANGETIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatusChangeTime").isBinary(false).build();

    private static final ConfigurationRecorderStatusMarshaller INSTANCE = new ConfigurationRecorderStatusMarshaller();

    private ConfigurationRecorderStatusMarshaller() {
    }

    public static ConfigurationRecorderStatusMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ConfigurationRecorderStatus configurationRecorderStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(configurationRecorderStatus, "configurationRecorderStatus");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(configurationRecorderStatus.name(), NAME_BINDING);
            protocolMarshaller.marshall(configurationRecorderStatus.lastStartTime(), LASTSTARTTIME_BINDING);
            protocolMarshaller.marshall(configurationRecorderStatus.lastStopTime(), LASTSTOPTIME_BINDING);
            protocolMarshaller.marshall(configurationRecorderStatus.recording(), RECORDING_BINDING);
            protocolMarshaller.marshall(configurationRecorderStatus.lastStatusString(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall(configurationRecorderStatus.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall(configurationRecorderStatus.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(configurationRecorderStatus.lastStatusChangeTime(), LASTSTATUSCHANGETIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
