/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.DeliveryChannel;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DeliveryChannel} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DeliveryChannelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3BucketName").isBinary(false).build();

    private static final MarshallingInfo<String> S3KEYPREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3KeyPrefix").isBinary(false).build();

    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snsTopicARN").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CONFIGSNAPSHOTDELIVERYPROPERTIES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("configSnapshotDeliveryProperties").isBinary(false).build();

    private static final DeliveryChannelMarshaller INSTANCE = new DeliveryChannelMarshaller();

    private DeliveryChannelMarshaller() {
    }

    public static DeliveryChannelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DeliveryChannel deliveryChannel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(deliveryChannel, "deliveryChannel");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(deliveryChannel.name(), NAME_BINDING);
            protocolMarshaller.marshall(deliveryChannel.s3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall(deliveryChannel.s3KeyPrefix(), S3KEYPREFIX_BINDING);
            protocolMarshaller.marshall(deliveryChannel.snsTopicARN(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(deliveryChannel.configSnapshotDeliveryProperties(),
                    CONFIGSNAPSHOTDELIVERYPROPERTIES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
