/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetComplianceDetailsByConfigRuleRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetComplianceDetailsByConfigRuleRequestModelMarshaller {
    private static final MarshallingInfo<String> CONFIGRULENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleName").isBinary(false).build();

    private static final MarshallingInfo<List> COMPLIANCETYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceTypes").isBinary(false).build();

    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();

    private static final GetComplianceDetailsByConfigRuleRequestModelMarshaller INSTANCE = new GetComplianceDetailsByConfigRuleRequestModelMarshaller();

    private GetComplianceDetailsByConfigRuleRequestModelMarshaller() {
    }

    public static GetComplianceDetailsByConfigRuleRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getComplianceDetailsByConfigRuleRequest, "getComplianceDetailsByConfigRuleRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getComplianceDetailsByConfigRuleRequest.configRuleName(), CONFIGRULENAME_BINDING);
            protocolMarshaller
                    .marshall(getComplianceDetailsByConfigRuleRequest.complianceTypesStrings(), COMPLIANCETYPES_BINDING);
            protocolMarshaller.marshall(getComplianceDetailsByConfigRuleRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall(getComplianceDetailsByConfigRuleRequest.nextToken(), NEXTTOKEN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
