/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.RecordingGroup;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RecordingGroup} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RecordingGroupMarshaller {
    private static final MarshallingInfo<Boolean> ALLSUPPORTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allSupported").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INCLUDEGLOBALRESOURCETYPES_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("includeGlobalResourceTypes").isBinary(false).build();

    private static final MarshallingInfo<List> RESOURCETYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceTypes").isBinary(false).build();

    private static final RecordingGroupMarshaller INSTANCE = new RecordingGroupMarshaller();

    private RecordingGroupMarshaller() {
    }

    public static RecordingGroupMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RecordingGroup recordingGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(recordingGroup, "recordingGroup");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(recordingGroup.allSupported(), ALLSUPPORTED_BINDING);
            protocolMarshaller.marshall(recordingGroup.includeGlobalResourceTypes(), INCLUDEGLOBALRESOURCETYPES_BINDING);
            protocolMarshaller.marshall(recordingGroup.resourceTypesStrings(), RESOURCETYPES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
