/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.EvaluationResultIdentifier;
import software.amazon.awssdk.services.config.transform.EvaluationResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EvaluationResult
implements StructuredPojo,
ToCopyableBuilder<Builder, EvaluationResult> {
    private final EvaluationResultIdentifier evaluationResultIdentifier;
    private final String complianceType;
    private final Instant resultRecordedTime;
    private final Instant configRuleInvokedTime;
    private final String annotation;
    private final String resultToken;

    private EvaluationResult(BuilderImpl builder) {
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.complianceType = builder.complianceType;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.annotation = builder.annotation;
        this.resultToken = builder.resultToken;
    }

    public EvaluationResultIdentifier evaluationResultIdentifier() {
        return this.evaluationResultIdentifier;
    }

    public ComplianceType complianceType() {
        return ComplianceType.fromValue(this.complianceType);
    }

    public String complianceTypeString() {
        return this.complianceType;
    }

    public Instant resultRecordedTime() {
        return this.resultRecordedTime;
    }

    public Instant configRuleInvokedTime() {
        return this.configRuleInvokedTime;
    }

    public String annotation() {
        return this.annotation;
    }

    public String resultToken() {
        return this.resultToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResultIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultRecordedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleInvokedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        return Objects.equals(this.evaluationResultIdentifier(), other.evaluationResultIdentifier()) && Objects.equals(this.complianceTypeString(), other.complianceTypeString()) && Objects.equals(this.resultRecordedTime(), other.resultRecordedTime()) && Objects.equals(this.configRuleInvokedTime(), other.configRuleInvokedTime()) && Objects.equals(this.annotation(), other.annotation()) && Objects.equals(this.resultToken(), other.resultToken());
    }

    public String toString() {
        return ToString.builder((String)"EvaluationResult").add("EvaluationResultIdentifier", (Object)this.evaluationResultIdentifier()).add("ComplianceType", (Object)this.complianceTypeString()).add("ResultRecordedTime", (Object)this.resultRecordedTime()).add("ConfigRuleInvokedTime", (Object)this.configRuleInvokedTime()).add("Annotation", (Object)this.annotation()).add("ResultToken", (Object)this.resultToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationResultIdentifier": {
                return Optional.of(clazz.cast(this.evaluationResultIdentifier()));
            }
            case "ComplianceType": {
                return Optional.of(clazz.cast(this.complianceTypeString()));
            }
            case "ResultRecordedTime": {
                return Optional.of(clazz.cast(this.resultRecordedTime()));
            }
            case "ConfigRuleInvokedTime": {
                return Optional.of(clazz.cast(this.configRuleInvokedTime()));
            }
            case "Annotation": {
                return Optional.of(clazz.cast(this.annotation()));
            }
            case "ResultToken": {
                return Optional.of(clazz.cast(this.resultToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationResultIdentifier evaluationResultIdentifier;
        private String complianceType;
        private Instant resultRecordedTime;
        private Instant configRuleInvokedTime;
        private String annotation;
        private String resultToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            this.evaluationResultIdentifier(model.evaluationResultIdentifier);
            this.complianceType(model.complianceType);
            this.resultRecordedTime(model.resultRecordedTime);
            this.configRuleInvokedTime(model.configRuleInvokedTime);
            this.annotation(model.annotation);
            this.resultToken(model.resultToken);
        }

        public final EvaluationResultIdentifier.Builder getEvaluationResultIdentifier() {
            return this.evaluationResultIdentifier != null ? this.evaluationResultIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier.BuilderImpl evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier != null ? evaluationResultIdentifier.build() : null;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Instant getResultRecordedTime() {
            return this.resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        public final Instant getConfigRuleInvokedTime() {
            return this.configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        public final String getAnnotation() {
            return this.annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final String getResultToken() {
            return this.resultToken;
        }

        @Override
        public final Builder resultToken(String resultToken) {
            this.resultToken = resultToken;
            return this;
        }

        public final void setResultToken(String resultToken) {
            this.resultToken = resultToken;
        }

        public EvaluationResult build() {
            return new EvaluationResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EvaluationResult> {
        public Builder evaluationResultIdentifier(EvaluationResultIdentifier var1);

        default public Builder evaluationResultIdentifier(Consumer<EvaluationResultIdentifier.Builder> evaluationResultIdentifier) {
            return this.evaluationResultIdentifier((EvaluationResultIdentifier)((EvaluationResultIdentifier.Builder)EvaluationResultIdentifier.builder().apply(evaluationResultIdentifier)).build());
        }

        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder resultRecordedTime(Instant var1);

        public Builder configRuleInvokedTime(Instant var1);

        public Builder annotation(String var1);

        public Builder resultToken(String var1);
    }
}

